/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.RemoteRequestException;
import org.jboss.remoting3.remote.Loggers;
import org.jboss.remoting3.remote.OutboundRequest;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.spi.LocalReplyHandler;
import org.jboss.remoting3.spi.SpiUtils;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

final class InboundReplyTask
implements Runnable {
    private final OutboundRequest outboundRequest;
    private RemoteConnectionHandler remoteConnectionHandler;
    private static final Logger log = Loggers.main;

    InboundReplyTask(RemoteConnectionHandler remoteConnectionHandler, OutboundRequest outboundRequest) {
        this.remoteConnectionHandler = remoteConnectionHandler;
        this.outboundRequest = outboundRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object reply;
        LocalReplyHandler replyHandler;
        OutboundRequest outboundRequest;
        OutboundRequest outboundRequest2 = outboundRequest = this.outboundRequest;
        synchronized (outboundRequest2) {
            replyHandler = outboundRequest.getInboundReplyHandler();
        }
        try {
            RemoteConnectionHandler connectionHandler = this.remoteConnectionHandler;
            Unmarshaller unmarshaller = connectionHandler.getMarshallerFactory().createUnmarshaller(connectionHandler.getMarshallingConfiguration());
            try {
                log.trace("Unmarshalling inbound reply");
                unmarshaller.start((ByteInput)outboundRequest.getByteInput());
                RemoteConnectionHandler old = RemoteConnectionHandler.setCurrent(connectionHandler);
                try {
                    reply = unmarshaller.readObject();
                    unmarshaller.close();
                }
                finally {
                    RemoteConnectionHandler.setCurrent(old);
                }
                log.trace("Unmarshalled inbound reply %s", reply);
            }
            finally {
                IoUtils.safeClose((Closeable)unmarshaller);
            }
        }
        catch (IOException e) {
            log.trace((Throwable)e, "Unmarshalling inbound reply failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, e);
            return;
        }
        catch (Exception e) {
            log.trace((Throwable)e, "Unmarshalling inbound reply failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, (IOException)new RemoteRequestException(e));
            return;
        }
        catch (Error e) {
            log.trace((Throwable)e, "Unmarshalling inbound reply failed", new Object[0]);
            SpiUtils.safeHandleException(replyHandler, (IOException)new RemoteRequestException(e));
            throw e;
        }
        SpiUtils.safeHandleReply(replyHandler, reply);
    }
}

