/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.Client;
import org.jboss.remoting3.ClientContext;
import org.jboss.remoting3.ClientListener;
import org.jboss.remoting3.RemoteExecutionException;
import org.jboss.remoting3.RequestContext;
import org.jboss.remoting3.RequestListener;
import org.jboss.remoting3.service.classtable.ClassLookupRequest;
import org.jboss.remoting3.service.classtable.ClassLookupResponse;
import org.jboss.xnio.OptionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RemoteClassTable
implements ClassTable {
    private final Client<ClassLookupRequest, ClassLookupResponse> resolver;
    private final ClientListener<ClassLookupRequest, ClassLookupResponse> clientListener = new RctClientListener();
    private final RequestListener<ClassLookupRequest, ClassLookupResponse> requestListener = new RctRequestListener();
    private final ConcurrentMap<Integer, FutureClass> remoteClasses = null;
    private final ConcurrentMap<Integer, Class<?>> localClasses = null;
    private final ConcurrentMap<Class<?>, IntWriter> localClassWriters = null;
    private volatile int seq;
    private static final AtomicIntegerFieldUpdater<RemoteClassTable> seqUpdater = AtomicIntegerFieldUpdater.newUpdater(RemoteClassTable.class, "seq");

    public RemoteClassTable(Client<ClassLookupRequest, ClassLookupResponse> resolver) {
        this.resolver = resolver;
    }

    public ClientListener<ClassLookupRequest, ClassLookupResponse> getClientListener() {
        return this.clientListener;
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) throws IOException {
        IntWriter writer = (IntWriter)this.localClassWriters.get(clazz);
        if (writer == null) {
            int id = seqUpdater.addAndGet(this, 97);
            writer = new IntWriter(id);
            IntWriter appearing = this.localClassWriters.putIfAbsent(clazz, writer);
            if (appearing != null) {
                return appearing;
            }
            this.localClasses.put(id, clazz);
        }
        return writer;
    }

    public Class<?> readClass(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        int id = unmarshaller.readInt();
        Integer idKey = id;
        FutureClass futureClass = (FutureClass)this.remoteClasses.get(idKey);
        if (futureClass != null) {
            return futureClass.getValue();
        }
        futureClass = new FutureClass();
        FutureClass appearing = this.remoteClasses.putIfAbsent(idKey, futureClass);
        if (appearing != null) {
            return appearing.getValue();
        }
        try {
            ClassLookupResponse response = this.resolver.invoke(new ClassLookupRequest(id));
            futureClass.setValue(response.getResolvedClass());
            return response.getResolvedClass();
        }
        catch (RemoteExecutionException e) {
            throw new ClassNotFoundException(e.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RctRequestListener
    implements RequestListener<ClassLookupRequest, ClassLookupResponse> {
        private RctRequestListener() {
        }

        @Override
        public void handleRequest(RequestContext<ClassLookupResponse> requestContext, ClassLookupRequest request) throws RemoteExecutionException {
            try {
                int id = request.getId();
                Integer idObj = id;
                Class localClass = (Class)RemoteClassTable.this.localClasses.get(idObj);
                if (localClass != null) {
                    requestContext.sendReply(new ClassLookupResponse(localClass));
                } else {
                    requestContext.sendFailure("No class found with an ID of #" + idObj, null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RctClientListener
    implements ClientListener<ClassLookupRequest, ClassLookupResponse> {
        private RctClientListener() {
        }

        @Override
        public RequestListener<ClassLookupRequest, ClassLookupResponse> handleClientOpen(ClientContext clientContext, OptionMap optionMap) {
            return RemoteClassTable.this.requestListener;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntWriter
    implements ClassTable.Writer {
        private final int value;

        private IntWriter(int value) {
            this.value = value;
        }

        public void writeClass(Marshaller marshaller, Class<?> clazz) throws IOException {
            marshaller.writeInt(this.value);
        }

        public int getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FutureClass {
        private Class<?> value;
        private boolean done;

        private FutureClass() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> getValue() throws IOException, ClassNotFoundException {
            FutureClass futureClass = this;
            synchronized (futureClass) {
                while (!this.done) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
                Class<?> result = this.value;
                if (result == null) {
                    throw new ClassNotFoundException();
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Class<?> value) {
            FutureClass futureClass = this;
            synchronized (futureClass) {
                this.value = value;
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            FutureClass futureClass = this;
            synchronized (futureClass) {
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDone(boolean done) {
            FutureClass futureClass = this;
            synchronized (futureClass) {
                this.done = done;
                this.notifyAll();
            }
        }
    }
}

