/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CopyOnWriteHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final boolean identity;
    private final Object writeLock;
    private volatile Map<K, V> map = Collections.emptyMap();

    CopyOnWriteHashMap() {
        this(new Object());
    }

    CopyOnWriteHashMap(Object writeLock) {
        this(false, writeLock);
    }

    CopyOnWriteHashMap(boolean identity, Object writeLock) {
        this.identity = identity;
        this.writeLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (old != null) {
                return old;
            }
            if (map.size() == 0) {
                this.map = Collections.singletonMap(key, value);
            } else {
                Map<K, V> copy = this.copy(map);
                copy.put(key, value);
                this.writeCopy(copy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        if (key == null || value == null) {
            return false;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (old == null) {
                return false;
            }
            if (map.size() == 1) {
                this.map = Collections.emptyMap();
            } else {
                Map<K, V> copy = this.copy(map);
                copy.remove(key);
                this.writeCopy(copy);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null) {
            return false;
        }
        if (newValue == null) {
            throw new NullPointerException("newValue is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (old == null) {
                return false;
            }
            if (map.size() == 1) {
                this.map = Collections.singletonMap(key, newValue);
            } else {
                Map<K, V> copy = this.copy(map);
                copy.put(key, newValue);
                this.writeCopy(copy);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (old != null) {
                if (map.size() == 1) {
                    this.map = Collections.singletonMap(key, value);
                } else {
                    Map<K, V> copy = this.copy(map);
                    copy.put(key, value);
                    this.writeCopy(copy);
                }
            }
            return old;
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (map.size() == 0) {
                this.map = Collections.singletonMap(key, value);
            } else {
                Map<K, V> copy = this.copy(map);
                copy.put(key, value);
                this.writeCopy(copy);
            }
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> map = this.map;
            V old = map.get(key);
            if (old != null) {
                if (map.size() == 1) {
                    this.map = Collections.emptyMap();
                } else {
                    Map<K, V> copy = this.copy(map);
                    copy.remove(key);
                    this.writeCopy(copy);
                }
            }
            return old;
        }
    }

    private Map<K, V> copy(Map<K, V> map) {
        return this.identity ? new IdentityHashMap<K, V>(map) : new HashMap<K, V>(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> orig) {
        if (orig == null) {
            throw new NullPointerException("map is null");
        }
        if (orig.isEmpty()) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            Map<K, V> copy = this.copy(this.map);
            for (Map.Entry<K, V> entry : orig.entrySet()) {
                copy.put(entry.getKey(), entry.getValue());
            }
            this.writeCopy(copy);
        }
    }

    private void writeCopy(Map<K, V> copy) {
        if (copy.isEmpty()) {
            this.map = Collections.emptyMap();
        } else if (copy.size() == 1) {
            Map.Entry<K, V> entry = copy.entrySet().iterator().next();
            this.map = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            this.map = copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.writeLock;
        synchronized (object) {
            this.map = Collections.emptyMap();
        }
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableMap(this.map).entrySet();
    }
}

