/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.aop.AbstractInterceptor;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ejb3.stateful.StatefulRemoveInterceptor;
import org.jboss.logging.Logger;

public class StatefulCacheInterceptor
extends AbstractInterceptor {
    private static final Logger log = Logger.getLogger(StatefulCacheInterceptor.class);

    public Object invoke(Invocation invocation) throws Throwable {
        StatefulContainerInvocation ejb = (StatefulContainerInvocation)invocation;
        Object id = ejb.getId();
        StatefulContainer container = (StatefulContainer)StatefulCacheInterceptor.getEJBContainer(invocation);
        StatefulBeanContext target = container.getCache().get(id);
        target.setInInvocation(true);
        StatefulBeanContext.currentBean.push(target);
        container.pushContext(target);
        try {
            if (target.isDiscarded()) {
                throw new EJBException("SFSB was discarded by another thread");
            }
            Object object = ejb.invokeNext();
            return object;
        }
        catch (Exception ex) {
            if (StatefulRemoveInterceptor.isApplicationException(ex, (MethodInvocation)invocation)) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing bean " + id + " because of exception"), (Throwable)ex);
                }
                container.getCache().remove(id);
                target.setDiscarded(true);
            }
            throw ex;
        }
        catch (Throwable t) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Removing bean " + id + " because of Throwable"), t);
            }
            container.getCache().remove(id);
            target.setDiscarded(true);
            throw t;
        }
        finally {
            container.popContext();
            StatefulBeanContext.currentBean.pop();
            target.setInInvocation(false);
            if (!target.isTxSynchronized() && !target.isDiscarded()) {
                container.getCache().release(target);
            }
        }
    }
}

