/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.resolvers;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

public class DefaultMessageDestinationReferenceResolver
implements MessageDestinationReferenceResolver {
    private static String findMessageDestination(DeploymentUnit deploymentUnit, MessageDestinationsMetaData destinations, String name) {
        if (destinations == null) {
            return null;
        }
        MessageDestinationMetaData destination = (MessageDestinationMetaData)destinations.get(name);
        if (destination != null) {
            String jndiName = destination.getMappedName();
            if (jndiName != null) {
                return jndiName;
            }
            throw new IllegalStateException("Message destination " + name + " in " + deploymentUnit + " does not define a mapped name");
        }
        return null;
    }

    private static String findWithinApplication(DeploymentUnit unit, String name) {
        String jndiName = DefaultMessageDestinationReferenceResolver.findWithinModule(unit, name);
        if (jndiName != null) {
            return jndiName;
        }
        for (DeploymentUnit child : unit.getChildren()) {
            jndiName = DefaultMessageDestinationReferenceResolver.findWithinApplication(child, name);
            if (jndiName == null) continue;
            return jndiName;
        }
        return null;
    }

    private static String findWithinModule(DeploymentUnit deploymentUnit, String name) {
        MessageDestinationsMetaData destinations;
        String jndiName;
        MessageDestinationsMetaData destinations2;
        String jndiName2;
        MessageDestinationsMetaData destinations3;
        String jndiName3;
        JBossMetaData ejbMetaData = (JBossMetaData)deploymentUnit.getAttachment(JBossMetaData.class);
        if (ejbMetaData != null && (jndiName3 = DefaultMessageDestinationReferenceResolver.findMessageDestination(deploymentUnit, destinations3 = ejbMetaData.getAssemblyDescriptor().getMessageDestinations(), name)) != null) {
            return jndiName3;
        }
        JBossWebMetaData webMetaData = (JBossWebMetaData)deploymentUnit.getAttachment(JBossWebMetaData.class);
        if (webMetaData != null && (jndiName2 = DefaultMessageDestinationReferenceResolver.findMessageDestination(deploymentUnit, destinations2 = webMetaData.getMessageDestinations(), name)) != null) {
            return jndiName2;
        }
        JBossClientMetaData clientMetaData = (JBossClientMetaData)deploymentUnit.getAttachment(JBossClientMetaData.class);
        if (clientMetaData != null && (jndiName = DefaultMessageDestinationReferenceResolver.findMessageDestination(deploymentUnit, destinations = clientMetaData.getMessageDestinations(), name)) != null) {
            return jndiName;
        }
        return null;
    }

    private static DeploymentUnit getDeploymentUnit(DeploymentUnit current, String path) {
        if (path.startsWith("/")) {
            return DefaultMessageDestinationReferenceResolver.getDeploymentUnit(current.getTopLevel(), path.substring(1));
        }
        if (path.startsWith("./")) {
            return DefaultMessageDestinationReferenceResolver.getDeploymentUnit(current, path.substring(2));
        }
        if (path.startsWith("../")) {
            return DefaultMessageDestinationReferenceResolver.getDeploymentUnit(current.getParent(), path.substring(3));
        }
        int i = path.indexOf(47);
        String name = i == -1 ? path : path.substring(0, i);
        for (DeploymentUnit child : current.getChildren()) {
            if (!child.getSimpleName().equals(name)) continue;
            return child;
        }
        throw new IllegalArgumentException("Can't find a deployment unit named " + name + " at " + current);
    }

    @Override
    public String resolveMessageDestinationJndiName(DeploymentUnit deploymentUnit, String link) {
        int i;
        int n = i = link == null ? -1 : link.indexOf(35);
        if (i != -1) {
            String path = link.substring(0, i);
            link = link.substring(i + 1);
            String jndiName = DefaultMessageDestinationReferenceResolver.findWithinModule(deploymentUnit = DefaultMessageDestinationReferenceResolver.getDeploymentUnit(deploymentUnit, "../" + path), link);
            if (jndiName != null) {
                return jndiName;
            }
        } else {
            String jndiName = DefaultMessageDestinationReferenceResolver.findWithinModule(deploymentUnit, link);
            if (jndiName != null) {
                return jndiName;
            }
            jndiName = DefaultMessageDestinationReferenceResolver.findWithinApplication(deploymentUnit.getTopLevel(), link);
            if (jndiName != null) {
                return jndiName;
            }
        }
        throw new IllegalArgumentException("Deployment unit " + deploymentUnit + " does not define a message destination " + link);
    }
}

