/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.core.businessobject;

import java.io.Serializable;
import java.util.HashSet;
import javax.naming.NamingException;
import org.jboss.ejb3.core.businessobject.BusinessObjectFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.util.CollectionHelper;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class LegacyStatelessBusinessObjectFactory
implements BusinessObjectFactory {
    @Override
    public <B> B createBusinessObject(SessionContainer container, Serializable sessionId, Class<B> intf) {
        assert (sessionId == null) : "sessionId is must be null for Stateless";
        assert (intf != null) : "intf is null";
        try {
            HashSet businessInterfaceNames = new HashSet();
            JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)container.getXml();
            CollectionHelper.addAllIfSet(businessInterfaceNames, smd.getBusinessRemotes());
            CollectionHelper.addAllIfSet(businessInterfaceNames, smd.getBusinessLocals());
            String interfaceName = intf.getName();
            if (!businessInterfaceNames.contains(interfaceName)) {
                throw new IllegalStateException("Cannot find BusinessObject for interface: " + interfaceName);
            }
            String jndiName = container.getXml().determineResolvedJndiName(interfaceName);
            return intf.cast(container.getInitialContext().lookup(jndiName));
        }
        catch (NamingException e) {
            throw new RuntimeException("failed to invoke getBusinessObject", e);
        }
    }
}

