/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.security.InvalidParameterException;
import java.util.Hashtable;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.EventProvider;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObjectMBean;
import org.jboss.management.j2ee.StateManageable;
import org.jboss.management.j2ee.statistics.StatisticsProvider;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.mx.util.ObjectNameConverter;

public abstract class J2EEManagedObject
extends JBossNotificationBroadcasterSupport
implements J2EEManagedObjectMBean,
MBeanRegistration {
    public static final String TYPE = "j2eeType";
    public static final String NAME = "name";
    private static Logger log = Logger.getLogger(J2EEManagedObject.class);
    private ObjectName parentName = null;
    private ObjectName name = null;
    protected MBeanServer server;

    protected static String getType(String pName) {
        String lType = null;
        if (pName != null) {
            ObjectName oname = J2EEManagedObject.newObjectName(pName);
            lType = oname.getKeyPropertyList().get(TYPE);
        }
        return lType == null ? "" : lType;
    }

    protected static String getType(ObjectName pName) {
        String lType = null;
        if (pName != null) {
            lType = pName.getKeyPropertyList().get(TYPE);
        }
        return lType == null ? "" : lType;
    }

    protected static ObjectName newObjectName(String pName) {
        try {
            return new ObjectName(pName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name: " + pName);
        }
    }

    protected static ObjectName removeObject(MBeanServer pServer, String pSearchCriteria) throws JMException {
        ObjectName lSearch = ObjectNameConverter.convert((String)pSearchCriteria);
        log.debug((Object)("removeObject(), search for: " + pSearchCriteria + ", search criteria: " + lSearch));
        Set<ObjectName> lNames = pServer.queryNames(lSearch, null);
        if (!lNames.isEmpty()) {
            ObjectName lName = lNames.iterator().next();
            pServer.unregisterMBean(lName);
            return lName;
        }
        return null;
    }

    protected static ObjectName removeObject(MBeanServer pServer, String pName, String pSearchCriteria) throws JMException {
        String lEncryptedName = ObjectNameConverter.convertCharacters((String)pName, (boolean)true);
        ObjectName lSearch = new ObjectName(pSearchCriteria + "," + NAME + "=" + lEncryptedName);
        log.debug((Object)("removeObject(), name: " + pName + ", encrypted name: " + lEncryptedName + ", search criteria: " + lSearch));
        Set<ObjectName> lNames = pServer.queryNames(lSearch, null);
        if (!lNames.isEmpty()) {
            ObjectName lName = lNames.iterator().next();
            pServer.unregisterMBean(lName);
            return lName;
        }
        return null;
    }

    public J2EEManagedObject(String domainName, String j2eeType, String resName) throws MalformedObjectNameException {
        log = Logger.getLogger(this.getClass());
        if (domainName == null) {
            throw new InvalidParameterException("Domain Name must be set");
        }
        Hashtable<String, String> lProperties = new Hashtable<String, String>();
        lProperties.put(TYPE, j2eeType);
        lProperties.put(NAME, resName);
        this.name = ObjectNameConverter.convert((String)domainName, lProperties);
        log.debug((Object)("ctor, name: " + this.name));
    }

    public J2EEManagedObject(String j2eeType, String resName, ObjectName jsr77ParentName) throws MalformedObjectNameException, InvalidParentException {
        log = Logger.getLogger(this.getClass());
        Hashtable lProperties = this.getParentKeys(jsr77ParentName);
        lProperties.put(TYPE, j2eeType);
        lProperties.put(NAME, resName);
        this.name = ObjectNameConverter.convert((String)J2EEDomain.getDomainName(), (Hashtable)lProperties);
        this.setparent(jsr77ParentName.getCanonicalName());
    }

    public Logger getLog() {
        return log;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public ObjectName getObjectName() {
        return this.name;
    }

    public String getobjectName() {
        return this.name.getCanonicalName();
    }

    public String getparent() {
        String parent = null;
        if (this.parentName != null) {
            parent = this.parentName.getCanonicalName();
        }
        return parent;
    }

    public void setparent(String pParent) throws InvalidParentException {
        if (pParent == null) {
            throw new InvalidParameterException("Parent must be set");
        }
        this.parentName = J2EEManagedObject.newObjectName(pParent);
    }

    public void addChild(ObjectName pChild) {
    }

    public void removeChild(ObjectName pChild) {
    }

    public boolean isstateManageable() {
        return this instanceof StateManageable;
    }

    public boolean isstatisticsProvider() {
        return this instanceof StatisticsProvider;
    }

    public boolean iseventProvider() {
        return this instanceof EventProvider;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.server = server;
        return name;
    }

    public final void postRegister(Boolean registrationDone) {
        block5: {
            try {
                log.debug((Object)("postRegister(), parent: " + this.parentName));
                if (!registrationDone.booleanValue()) break block5;
                this.postCreation();
                if (this.parentName == null) break block5;
                try {
                    if (this.parentName.getKeyProperty(NAME).compareTo("null") != 0) {
                        this.getServer().invoke(this.parentName, "addChild", new Object[]{this.name}, new String[]{ObjectName.class.getName()});
                        break block5;
                    }
                    ObjectName j2eeServerName = J2EEDomain.getDomainServerName(this.server);
                    this.server.invoke(j2eeServerName, "addChild", new Object[]{this.name}, new String[]{ObjectName.class.getName()});
                }
                catch (JMException e) {
                    log.debug((Object)"Failed to add child", (Throwable)e);
                    registrationDone = Boolean.FALSE;
                }
            }
            catch (RuntimeException re) {
                log.debug((Object)"postRegister() caught this exception", (Throwable)re);
                throw re;
            }
        }
    }

    public final void preDeregister() throws Exception {
        log.debug((Object)("preDeregister(), parent: " + this.parentName));
        if (this.parentName != null) {
            try {
                this.server.invoke(this.parentName, "removeChild", new Object[]{this.name}, new String[]{ObjectName.class.getName()});
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
            this.preDestruction();
        }
    }

    public void postDeregister() {
        this.server = null;
    }

    public void sendNotification(String type, String info) {
        Notification msg = new Notification(type, this.getObjectName(), this.getNextNotificationSequenceNumber(), System.currentTimeMillis(), info);
        super.sendNotification(msg);
    }

    public String toString() {
        return "J2EEManagedObject [ name: " + this.name + ", parent: " + this.parentName + " ];";
    }

    protected void postCreation() {
    }

    protected void preDestruction() {
    }

    protected Hashtable getParentKeys(ObjectName pParent) {
        return new Hashtable();
    }

    protected long getNextNotificationSequenceNumber() {
        return super.nextNotificationSequenceNumber();
    }
}

