/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn.config.xml;

import java.net.URL;
import java.util.Map;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceResourceResolver
implements LSResourceResolver {
    private final Map<String, Map<String, URL>> types;
    private final DOMImplementationLS implementation;

    public NamespaceResourceResolver(Map<String, Map<String, URL>> types) {
        this(types, NamespaceResourceResolver.defaultImplementation());
    }

    public NamespaceResourceResolver(Map<String, Map<String, URL>> types, DOMImplementationLS implementation) {
        this.types = types;
        this.implementation = implementation;
    }

    private static DOMImplementationLS defaultImplementation() {
        try {
            return (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        URL url;
        LSInput input = this.implementation.createLSInput();
        input.setPublicId(publicId);
        input.setSystemId(systemId);
        input.setBaseURI(baseURI);
        Map<String, URL> namespaces = this.types.get(type);
        if (namespaces != null && (url = namespaces.get(namespaceURI)) != null) {
            input.setSystemId(url.toString());
        }
        return input;
    }
}

