/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.ispn;

import java.util.Locale;
import java.util.Properties;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.jmx.ComponentsJmxRegistration;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.jboss.ha.ispn.CacheContainerConfiguration;
import org.jboss.ha.ispn.CacheContainerFactory;
import org.jboss.ha.ispn.DefaultCacheContainer;
import org.jboss.logging.Logger;
import org.jgroups.Channel;
import org.jgroups.ChannelFactory;

@Listener
public class DefaultCacheContainerFactory
implements CacheContainerFactory,
MBeanServerLookup {
    public static final String CHANNEL_ID = "channelId";
    public static final String CHANNEL_FACTORY = "channelFactory";
    private static Logger logger = Logger.getLogger(DefaultCacheContainerFactory.class);
    private final ChannelFactory channelFactory;
    private final MBeanServer server;

    public DefaultCacheContainerFactory(ChannelFactory channelFactory, MBeanServer server) {
        this.channelFactory = channelFactory;
        this.server = server;
    }

    public EmbeddedCacheManager createCacheContainer(CacheContainerConfiguration configuration) {
        GlobalConfiguration global = configuration.getGlobalConfiguration();
        global.setShutdownHookBehavior(GlobalConfiguration.ShutdownHookBehavior.DONT_REGISTER);
        global.setMBeanServerLookup((MBeanServerLookup)this);
        if (global.getTransportClass() != null) {
            global.setStrictPeerToPeer(false);
            Properties properties = global.getTransportProperties();
            if (!properties.containsKey("channelLookup")) {
                properties.put(CHANNEL_FACTORY, this.channelFactory);
                properties.setProperty(CHANNEL_ID, global.getClusterName());
                properties.setProperty("channelLookup", ChannelFactoryChannelLookup.class.getName());
            }
        }
        DefaultCacheManager manager = new DefaultCacheManager(global, configuration.getDefaultConfiguration(), false);
        for (Configuration config : configuration.getNamedConfigurations()) {
            manager.defineConfiguration(config.getName(), config);
        }
        return new DefaultCacheContainer((EmbeddedCacheManager)manager);
    }

    public MBeanServer getMBeanServer(Properties properties) {
        return this.server;
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        DefaultCacheContainerFactory.log("Started", event.getCacheName(), event.getCacheManager());
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        Configuration configuration;
        String cacheName = event.getCacheName();
        EmbeddedCacheManager container = event.getCacheManager();
        DefaultCacheContainerFactory.log("Stopped", cacheName, container);
        Configuration configuration2 = configuration = cacheName.equals("___defaultcache") ? container.getDefaultConfiguration() : container.defineConfiguration(cacheName, new Configuration());
        if (configuration.isExposeJmxStatistics()) {
            GlobalConfiguration global = container.getGlobalConfiguration();
            String domain = global.getJmxDomain();
            String jmxCacheName = String.format("%s(%s)", cacheName, configuration.getCacheModeString().toLowerCase(Locale.ENGLISH));
            String containerName = global.getCacheManagerName();
            try {
                ObjectName name = ObjectName.getInstance(String.format("%s:%s,%s=%s,manager=%s,%s=%s", domain, "type=Cache", ComponentsJmxRegistration.NAME_KEY, ObjectName.quote(jmxCacheName), ObjectName.quote(containerName), ComponentsJmxRegistration.COMPONENT_KEY, "Cache"));
                if (this.server.isRegistered(name)) {
                    this.server.unregisterMBean(name);
                    logger.debug((Object)String.format("Unregistered cache mbean: %s", name));
                }
            }
            catch (JMException e) {
                logger.warn((Object)String.format("Failed to unregister mbean for %s cache", cacheName), (Throwable)e);
            }
        }
    }

    private static void log(String event, String cacheName, EmbeddedCacheManager container) {
        logger.info((Object)String.format("%s \"%s\" cache from \"%s\" container", event, cacheName, container.getGlobalConfiguration().getCacheManagerName()));
    }

    public static class ChannelFactoryChannelLookup
    implements JGroupsChannelLookup {
        public static final String STACK = "stack";
        public static final String DEFAULT_STACK = "udp";
        public static final String AUTO_START = "auto-start";
        public static final String DEFAULT_AUTO_START = Boolean.toString(true);
        public static final String AUTO_STOP = "auto-stop";
        public static final String DEFAULT_AUTO_STOP = Boolean.toString(true);
        private boolean autoStart = true;
        private boolean autoStop = true;

        public Channel getJGroupsChannel(Properties properties) {
            this.autoStart = Boolean.valueOf(properties.getProperty(AUTO_START, DEFAULT_AUTO_START));
            this.autoStop = Boolean.valueOf(properties.getProperty(AUTO_STOP, DEFAULT_AUTO_STOP));
            String stack = properties.getProperty(STACK, DEFAULT_STACK);
            String id = properties.getProperty(DefaultCacheContainerFactory.CHANNEL_ID);
            ChannelFactory factory = (ChannelFactory)properties.get(DefaultCacheContainerFactory.CHANNEL_FACTORY);
            try {
                return factory.createMultiplexerChannel(stack, id);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean shouldStartAndConnect() {
            return this.autoStart;
        }

        public boolean shouldStopAndDisconnect() {
            return this.autoStop;
        }
    }
}

