/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hsqldb.util.RCData;
import org.hsqldb.util.SqlFile;
import org.hsqldb.util.SqlToolError;
import org.hsqldb.util.SqltoolRB;

public class SqlTool {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static String revnum = null;
    public static final int SQLTOOLERR_EXITVAL = 1;
    public static final int SYNTAXERR_EXITVAL = 11;
    public static final int RCERR_EXITVAL = 2;
    public static final int SQLERR_EXITVAL = 3;
    public static final int IOERR_EXITVAL = 4;
    public static final int FILEERR_EXITVAL = 5;
    public static final int INPUTERR_EXITVAL = 6;
    public static final int CONNECTERR_EXITVAL = 7;
    private static String CMDLINE_ID = "cmdline";
    private static SqltoolRB rb = null;
    public static String LS;
    private static BadCmdline bcl;

    private static String promptForPassword(String string) throws PrivateException {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(rb.getString(SqltoolRB.PASSWORDFOR_PROMPT, RCData.expandSysPropVars(string)));
            string2 = bufferedReader.readLine();
            string2 = string2 == null ? "" : string2.trim();
        }
        catch (IOException iOException) {
            throw new PrivateException(iOException.getMessage());
        }
        return string2;
    }

    private static void varParser(String string, Map map, boolean bl) throws PrivateException {
        if (map == null || string == null) {
            throw new IllegalArgumentException("varMap or varString are null in SqlTool.varParser call");
        }
        String[] stringArray = string.split("\\s*,\\s*");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf(61);
            if (n < 1) {
                throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
            }
            String string2 = stringArray[i].substring(0, n).trim();
            String string3 = stringArray[i].substring(n + 1).trim();
            if (string2.length() < 1) {
                throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
            }
            if (bl) {
                string2 = string2.toLowerCase();
            }
            map.put(string2, string3);
        }
    }

    public static void main(String[] stringArray) {
        try {
            SqlTool.objectMain(stringArray);
        }
        catch (SqlToolException sqlToolException) {
            if (sqlToolException.getMessage() != null) {
                System.err.println(sqlToolException.getMessage());
            }
            System.exit(sqlToolException.exitValue);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void objectMain(String[] stringArray) throws SqlToolException {
        RCData rCData;
        File file;
        block85: {
            int n;
            File[] fileArray;
            File[] fileArray2;
            AutoCloseable autoCloseable;
            String string = null;
            file = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            File[] fileArray3 = null;
            int n2 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            Boolean bl7 = null;
            Boolean bl8 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            HashMap hashMap = null;
            try {
                while (n2 + 1 < stringArray.length && stringArray[n2 + 1].startsWith("--") && stringArray[++n2].length() != 2) {
                    String string12 = stringArray[n2].substring(2).toLowerCase();
                    if (string12.equals("help")) {
                        System.out.println(rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbcDriver"));
                        return;
                    }
                    if (string12.equals("abortonerr")) {
                        if (bl7 != null) {
                            throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
                        }
                        bl7 = Boolean.FALSE;
                        continue;
                    }
                    if (string12.equals("continueonerr")) {
                        if (bl7 != null) {
                            throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
                        }
                        bl7 = Boolean.TRUE;
                        continue;
                    }
                    if (string12.equals("list")) {
                        bl2 = true;
                        continue;
                    }
                    if (string12.equals("rcfile")) {
                        if (++n2 == stringArray.length) {
                            throw bcl;
                        }
                        string = stringArray[n2];
                        continue;
                    }
                    if (string12.equals("setvar")) {
                        if (++n2 == stringArray.length) {
                            throw bcl;
                        }
                        string5 = stringArray[n2];
                        continue;
                    }
                    if (string12.equals("sql")) {
                        bl4 = true;
                        if (++n2 == stringArray.length) {
                            throw bcl;
                        }
                        string2 = stringArray[n2];
                        continue;
                    }
                    if (string12.equals("debug")) {
                        bl = true;
                        continue;
                    }
                    if (string12.equals("noautofile")) {
                        bl5 = true;
                        continue;
                    }
                    if (string12.equals("autocommit")) {
                        bl6 = true;
                        continue;
                    }
                    if (string12.equals("stdinput")) {
                        bl4 = false;
                        bl8 = Boolean.TRUE;
                        continue;
                    }
                    if (string12.equals("noinput")) {
                        bl4 = true;
                        bl8 = Boolean.FALSE;
                        continue;
                    }
                    if (string12.equals("driver")) {
                        if (++n2 == stringArray.length) {
                            throw bcl;
                        }
                        string3 = stringArray[n2];
                        continue;
                    }
                    if (string12.equals("inlinerc")) {
                        if (++n2 == stringArray.length) {
                            throw bcl;
                        }
                        string6 = stringArray[n2];
                        continue;
                    }
                    throw bcl;
                }
                if (!bl2 && string6 == null) {
                    if (++n2 == stringArray.length) {
                        throw bcl;
                    }
                    string4 = stringArray[n2];
                }
                int n3 = 0;
                if (string2 != null) {
                    try {
                        file = File.createTempFile("sqltool-", ".sql");
                        autoCloseable = new FileWriter(file);
                        try {
                            ((Writer)autoCloseable).write("/* " + new Date() + ".  " + SqlTool.class.getName() + " command-line SQL. */" + LS + LS);
                            ((Writer)autoCloseable).write(string2 + LS);
                            ((OutputStreamWriter)autoCloseable).flush();
                            fileArray2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var28_35 = null;
                            ((OutputStreamWriter)autoCloseable).close();
                            throw throwable;
                        }
                        ((OutputStreamWriter)autoCloseable).close();
                        {
                        }
                    }
                    catch (IOException iOException) {
                        throw new SqlToolException(4, rb.getString(SqltoolRB.SQLTEMPFILE_FAIL, iOException.toString()));
                    }
                }
                if (bl8 != null) {
                    bl4 = bl8 == false;
                }
                boolean bl9 = bl3 = !bl4 && stringArray.length <= n2 + 1;
                if (stringArray.length == n2 + 2 && stringArray[n2 + 1].equals("-")) {
                    if (bl8 == null) {
                        bl4 = false;
                    }
                } else if (stringArray.length > n2 + 1) {
                    fileArray3 = new File[stringArray.length - n2 - 1 + (bl8 == null || bl8 == false ? 0 : 1)];
                    if (bl) {
                        System.err.println("scriptFiles has " + fileArray3.length + " elements");
                    }
                    while (n2 + 1 < stringArray.length) {
                        fileArray3[n3++] = new File(stringArray[++n2]);
                    }
                    if (bl8 != null && bl8.booleanValue()) {
                        fileArray3[n3++] = null;
                        bl4 = true;
                    }
                }
            }
            catch (BadCmdline badCmdline) {
                throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbcDriver"));
            }
            rCData = null;
            if (string6 != null) {
                hashMap = new HashMap();
                try {
                    SqlTool.varParser(string6, hashMap, true);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(11, privateException.getMessage());
                }
                string7 = (String)hashMap.remove("url");
                string8 = (String)hashMap.remove("user");
                string10 = (String)hashMap.remove("charset");
                string11 = (String)hashMap.remove("truststore");
                string9 = (String)hashMap.remove("password");
                if (string7 == null || string7.length() < 1) {
                    throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_INLINEURL_MISSING));
                }
                if (string8 == null || string8.length() < 1) {
                    throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_INLINEUSERNAME_MISSING));
                }
                if (string9 != null && string9.length() > 0) {
                    throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_PASSWORD_VISIBLE));
                }
                if (hashMap.size() > 0) {
                    throw new SqlToolException(6, rb.getString(SqltoolRB.RCDATA_INLINE_EXTRAVARS, hashMap.keySet().toString()));
                }
                if (string9 == null) {
                    try {
                        string9 = SqlTool.promptForPassword(string8);
                    }
                    catch (PrivateException privateException) {
                        throw new SqlToolException(6, rb.getString(SqltoolRB.PASSWORD_READFAIL, privateException.getMessage()));
                    }
                }
                try {
                    rCData = new RCData(CMDLINE_ID, string7, string8, string9, string3, string10, string11);
                }
                catch (Exception exception) {
                    throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_GENFROMVALUES_FAIL, exception.getMessage()));
                }
            }
            try {
                rCData = new RCData(new File(string == null ? DEFAULT_RCFILE : string), string4);
            }
            catch (Exception exception) {
                throw new SqlToolException(2, rb.getString(SqltoolRB.CONNDATA_RETRIEVAL_FAIL, string4, exception.getMessage()));
            }
            if (bl2) {
                return;
            }
            if (bl) {
                rCData.report();
            }
            autoCloseable = null;
            try {
                autoCloseable = rCData.getConnection(string3, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
                autoCloseable.setAutoCommit(bl6);
                fileArray = null;
                if (bl3 && (fileArray = autoCloseable.getMetaData()) != null) {
                    System.out.println(rb.getString(SqltoolRB.JDBC_ESTABLISHED, fileArray.getDatabaseProductName(), fileArray.getDatabaseProductVersion(), fileArray.getUserName()));
                }
            }
            catch (Exception exception) {
                throw new SqlToolException(7, rb.getString(SqltoolRB.CONNECTION_FAIL, rCData.url, rCData.username, exception.getMessage()));
            }
            fileArray = new File[]{};
            fileArray2 = new File[]{null};
            File file2 = null;
            if (!(!bl3 || bl5 || (file2 = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && file2.canRead())) {
                file2 = null;
            }
            if (fileArray3 == null) {
                fileArray3 = bl4 ? fileArray : fileArray2;
            }
            int n4 = fileArray3.length;
            if (file != null) {
                ++n4;
            }
            if (file2 != null) {
                ++n4;
            }
            SqlFile[] sqlFileArray = new SqlFile[n4];
            HashMap hashMap2 = new HashMap();
            if (string5 != null) {
                try {
                    SqlTool.varParser(string5, hashMap2, false);
                }
                catch (PrivateException privateException) {
                    throw new SqlToolException(2, privateException.getMessage());
                }
            }
            int n5 = -1;
            try {
                n = 0;
                if (file2 != null) {
                    sqlFileArray[n++] = new SqlFile(file2, false, hashMap2);
                }
                if (file != null) {
                    sqlFileArray[n++] = new SqlFile(file, false, hashMap2);
                }
                for (int i = 0; i < fileArray3.length; ++i) {
                    if (n5 < 0 && bl3) {
                        n5 = n;
                    }
                    sqlFileArray[n++] = new SqlFile(fileArray3[i], bl3, hashMap2);
                }
            }
            catch (IOException iOException) {
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SqlToolException(5, iOException.getMessage());
            }
            for (n = 0; n < sqlFileArray.length; ++n) {
                if (n == n5) {
                    System.out.print("SqlTool v. " + revnum + ".                        ");
                }
                sqlFileArray[n].execute((Connection)autoCloseable, bl7);
            }
            Object var37_51 = null;
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {}
            break block85;
            {
                catch (SqlToolError sqlToolError) {
                    throw new SqlToolException(1);
                }
                catch (SQLException sQLException) {
                    throw new SqlToolException(3);
                }
            }
            catch (Throwable throwable) {
                Object var37_52 = null;
                try {
                    autoCloseable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (file != null && !file.delete()) {
            System.err.println(rCData.url + rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, file.toString()));
        }
    }

    static {
        revnum = "333";
        try {
            rb = new SqltoolRB();
            rb.validate();
            rb.setMissingPosValueBehavior(2);
            rb.setMissingPropertyBehavior(2);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Failed to initialize resource bundle");
            throw runtimeException;
        }
        LS = System.getProperty("line.separator");
        bcl = new BadCmdline();
    }

    public static class SqlToolException
    extends Exception {
        static final long serialVersionUID = 1424909871915188519L;
        int exitValue = 1;

        SqlToolException(String string, int n) {
            super(string);
            this.exitValue = n;
        }

        SqlToolException(int n, String string) {
            this(string, n);
        }

        SqlToolException(int n) {
            this.exitValue = n;
        }
    }

    private static class PrivateException
    extends Exception {
        static final long serialVersionUID = -7765061479594523462L;

        PrivateException() {
        }

        PrivateException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        static final long serialVersionUID = -2134764796788108325L;

        BadCmdline() {
        }
    }
}

