/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.wsrm.server.RMServerSequence;

public final class RMStore {
    private static final Logger logger = Logger.getLogger(RMStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void serialize(String dataDir, RMServerSequence seq) {
        File dir = new File(dataDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File sequenceFile = new File(dir, seq.getId());
        if (seq.isTerminated() && sequenceFile.exists()) {
            sequenceFile.delete();
            return;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(sequenceFile);
            fos.write(seq.toByteArray());
        }
        catch (IOException ioe) {
            logger.error((Object)("Can't write sequence to file " + sequenceFile.getName()), (Throwable)ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    logger.error((Object)("Can't close sequence file " + sequenceFile.getName()), (Throwable)ioe);
                }
            }
        }
    }

    public static final RMServerSequence deserialize(String dataDir, String seqId, boolean inbound) {
        File[] sequences = new File(dataDir).listFiles();
        for (int i = 0; i < sequences.length; ++i) {
            try {
                boolean matches;
                RMServerSequence sequence = new RMServerSequence(sequences[i]);
                boolean bl = matches = inbound ? sequence.getInboundId().equals(seqId) : sequence.getOutboundId().equals(seqId);
                if (matches) {
                    return sequence;
                }
                if (sequence.getCreationTime() + sequence.getDuration() < System.currentTimeMillis()) continue;
                sequences[i].delete();
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)("Can't read sequence from file " + sequences[i].getName()), (Throwable)ioe);
            }
        }
        return null;
    }
}

