/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public class SOAPMessageDispatcher {
    private static Logger log = Logger.getLogger(SOAPMessageDispatcher.class);

    public OperationMetaData getDispatchDestination(EndpointMetaData epMetaData, SOAPMessage soapMessage) throws SOAPException {
        OperationMetaData opMetaData = null;
        boolean debugEnabled = log.isDebugEnabled();
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties inProps = (AddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
        if (inProps != null && inProps.getAction() != null) {
            String wsaAction = inProps.getAction().getURI().toASCIIString();
            for (OperationMetaData opAux : epMetaData.getOperations()) {
                if (!wsaAction.equals(opAux.getSOAPAction())) continue;
                opMetaData = opAux;
                if (!debugEnabled) break;
                log.debug((Object)("Use wsa:Action dispatch: " + wsaAction));
                break;
            }
        }
        if (opMetaData == null && epMetaData.getServiceMode() != null) {
            QName xmlName = new QName(epMetaData.getPortName().getNamespaceURI(), "invoke");
            opMetaData = epMetaData.getOperation(xmlName);
        }
        if (opMetaData == null) {
            SOAPBody soapBody = soapMessage.getSOAPBody();
            SOAPBodyElement soapBodyElement = null;
            Iterator bodyChildren = soapBody.getChildElements();
            while (bodyChildren.hasNext() && soapBodyElement == null) {
                Object childNode = bodyChildren.next();
                if (!(childNode instanceof SOAPBodyElement)) continue;
                soapBodyElement = (SOAPBodyElement)childNode;
            }
            if (soapBodyElement == null) {
                boolean wsrmDisabled;
                boolean bl = wsrmDisabled = epMetaData.getConfig().getRMMetaData() == null;
                if (epMetaData.getStyle() == Style.RPC && wsrmDisabled) {
                    throw new SOAPException("Empty SOAP body with no child element not supported for RPC");
                }
                for (OperationMetaData opAux : epMetaData.getOperations()) {
                    if (opAux.getParameters().size() != 0) continue;
                    log.debug((Object)"Dispatching empty SOAP body");
                    opMetaData = opAux;
                    break;
                }
            } else {
                Name soapName = soapBodyElement.getElementName();
                QName xmlElementName = new QName(soapName.getURI(), soapName.getLocalName());
                opMetaData = epMetaData.getOperation(xmlElementName);
            }
        }
        if (opMetaData == null) {
            for (OperationMetaData opAux : epMetaData.getOperations()) {
                if (!opAux.isMessageEndpoint()) continue;
                log.debug((Object)"Use generic message style dispatch");
                opMetaData = opAux;
                break;
            }
        }
        if (debugEnabled) {
            log.debug((Object)("getDispatchDestination: " + (opMetaData != null ? opMetaData.getQName() : null)));
        }
        return opMetaData;
    }
}

