/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.jopr;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.integration.hornetq.jopr.JMSComponent;
import org.jboss.as.integration.hornetq.jopr.JMSConstants;
import org.jboss.as.integration.hornetq.jopr.JMSResourceComponent;
import org.jboss.as.integration.hornetq.jopr.util.ManagementSupport;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSManagerComponent
extends JMSResourceComponent
implements ResourceComponent,
CreateChildResourceFacet,
JMSComponent {
    @Override
    public void getValues(MeasurementReport measurementReport, Set<MeasurementScheduleRequest> measurementScheduleRequests) throws Exception {
        for (MeasurementScheduleRequest measurementScheduleRequest : measurementScheduleRequests) {
            if ("provider".equalsIgnoreCase(measurementScheduleRequest.getName())) {
                measurementReport.addData(new MeasurementDataTrait(measurementScheduleRequest, "HornetQ"));
                continue;
            }
            if (!"started".equalsIgnoreCase(measurementScheduleRequest.getName())) continue;
            ManagementView managementView = this.getProfileService();
            ManagedOperation operation = ManagementSupport.getOperation(managementView, "JMSServerMO", "isStarted", new ComponentType("JMSManage", "ServerManage"));
            SimpleValueSupport support = (SimpleValueSupport)operation.invoke(new MetaValue[0]);
            measurementReport.addData(new MeasurementDataTrait(measurementScheduleRequest, support.getValue().toString()));
        }
    }

    public CreateResourceReport createResource(CreateResourceReport createResourceReport) {
        createResourceReport.setStatus(CreateResourceStatus.IN_PROGRESS);
        ManagementView managementView = null;
        try {
            managementView = this.getProfileService();
        }
        catch (Exception e) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
            return createResourceReport;
        }
        Map simpleProps = createResourceReport.getResourceConfiguration().getSimpleProperties();
        try {
            if ("JMS Connection Factory".equalsIgnoreCase(createResourceReport.getResourceType().getName())) {
                String name = ((PropertySimple)simpleProps.get("name")).getStringValue();
                String connectorNames = ((PropertySimple)simpleProps.get("connectorNames")).getStringValue();
                boolean ha = ((PropertySimple)simpleProps.get("ha")).getBooleanValue();
                boolean useDiscovery = ((PropertySimple)simpleProps.get("useDiscovery")).getBooleanValue();
                int cfType = ((PropertySimple)simpleProps.get("cfType")).getIntegerValue();
                String bindings = ((PropertySimple)simpleProps.get("Bindings")).getStringValue();
                String clientId = ((PropertySimple)simpleProps.get("ClientID")).getStringValue();
                int dupsOkBatchSize = ((PropertySimple)simpleProps.get("DupsOKBatchSize")).getIntegerValue();
                int transactionBatchSize = ((PropertySimple)simpleProps.get("TransactionBatchSize")).getIntegerValue();
                long clientFailureCheckPeriod = ((PropertySimple)simpleProps.get("ClientFailureCheckPeriod")).getLongValue();
                long connectionTTL = ((PropertySimple)simpleProps.get("ConnectionTTL")).getLongValue();
                long callTimeout = ((PropertySimple)simpleProps.get("CallTimeout")).getLongValue();
                int consumerWindowSize = ((PropertySimple)simpleProps.get("ConsumerWindowSize")).getIntegerValue();
                int confirmationWindowSize = ((PropertySimple)simpleProps.get("ConfirmationWindowSize")).getIntegerValue();
                int producerMaxRate = ((PropertySimple)simpleProps.get("ProducerMaxRate")).getIntegerValue();
                int producerWindowSize = ((PropertySimple)simpleProps.get("ProducerWindowSize")).getIntegerValue();
                boolean cacheLargeMessageClient = ((PropertySimple)simpleProps.get("CacheLargeMessagesClient")).getBooleanValue();
                int minLargeMessageSize = ((PropertySimple)simpleProps.get("MinLargeMessageSize")).getIntegerValue();
                boolean blockOnNonDurableSend = ((PropertySimple)simpleProps.get("BlockOnNonDurableSend")).getBooleanValue();
                boolean blockOnAcknowledge = ((PropertySimple)simpleProps.get("BlockOnAcknowledge")).getBooleanValue();
                boolean blockOnDurableSend = ((PropertySimple)simpleProps.get("BlockOnDurableSend")).getBooleanValue();
                boolean autoGroup = ((PropertySimple)simpleProps.get("AutoGroup")).getBooleanValue();
                boolean preAcknowledge = ((PropertySimple)simpleProps.get("PreAcknowledge")).getBooleanValue();
                long maxRetryInterval = ((PropertySimple)simpleProps.get("MaxRetryInterval")).getLongValue();
                double retryIntervalMultiplier = ((PropertySimple)simpleProps.get("RetryIntervalMultiplier")).getDoubleValue();
                int reconnectAttempts = ((PropertySimple)simpleProps.get("ReconnectAttempts")).getIntegerValue();
                int scheduledThreadPoolMaxSize = ((PropertySimple)simpleProps.get("ScheduledThreadPoolMaxSize")).getIntegerValue();
                int threadPoolMaxSize = ((PropertySimple)simpleProps.get("ThreadPoolMaxSize")).getIntegerValue();
                String groupId = ((PropertySimple)simpleProps.get("GroupID")).getStringValue();
                int initialMessagePacketSize = ((PropertySimple)simpleProps.get("InitialMessagePacketSize")).getIntegerValue();
                boolean useGlobalPools = ((PropertySimple)simpleProps.get("UseGlobalPools")).getBooleanValue();
                long retryInterval = ((PropertySimple)simpleProps.get("RetryInterval")).getLongValue();
                String connectionLoadBalancingPolicyClassName = ((PropertySimple)simpleProps.get("ConnectionLoadBalancingPolicyClassName")).getStringValue();
                this.createConnectionFactory(createResourceReport, managementView, name, connectorNames, ha, useDiscovery, cfType, bindings, clientId, dupsOkBatchSize, transactionBatchSize, clientFailureCheckPeriod, connectionTTL, callTimeout, consumerWindowSize, confirmationWindowSize, producerMaxRate, producerWindowSize, cacheLargeMessageClient, minLargeMessageSize, blockOnNonDurableSend, blockOnAcknowledge, blockOnDurableSend, autoGroup, preAcknowledge, maxRetryInterval, retryIntervalMultiplier, reconnectAttempts, scheduledThreadPoolMaxSize, threadPoolMaxSize, groupId, initialMessagePacketSize, useGlobalPools, retryInterval, connectionLoadBalancingPolicyClassName);
            } else {
                String name = ((PropertySimple)simpleProps.get("name")).getStringValue();
                String jndiName = ((PropertySimple)simpleProps.get("jndiBindings")).getStringValue();
                String DLA = ((PropertySimple)simpleProps.get("dla")).getStringValue();
                String expiryAddress = ((PropertySimple)simpleProps.get("expiryAddress")).getStringValue();
                int maxSize = ((PropertySimple)simpleProps.get("maxSize")).getIntegerValue();
                int pageSize = ((PropertySimple)simpleProps.get("pageSize")).getIntegerValue();
                int maxDeliveryAttempts = ((PropertySimple)simpleProps.get("maxDeliveryAttempts")).getIntegerValue();
                long redeliveryDelay = ((PropertySimple)simpleProps.get("redeliveryDelay")).getLongValue();
                boolean lastValueQueue = ((PropertySimple)simpleProps.get("lastValueQueue")).getBooleanValue();
                long redistributionDelay = ((PropertySimple)simpleProps.get("redistributionDelay")).getLongValue();
                boolean sendToDLAOnNoRoute = ((PropertySimple)simpleProps.get("sendToDLAOnNoRoute")).getBooleanValue();
                String addressFullMessagePolicy = ((PropertySimple)simpleProps.get("addressFullMessagePolicy")).getStringValue();
                if ("JMS Queue".equalsIgnoreCase(createResourceReport.getResourceType().getName())) {
                    this.createQueue(createResourceReport, managementView, name, jndiName, DLA, expiryAddress, maxSize, pageSize, maxDeliveryAttempts, redeliveryDelay, lastValueQueue, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
                } else if ("JMS Topic".equalsIgnoreCase(createResourceReport.getResourceType().getName())) {
                    this.createTopic(createResourceReport, managementView, name, jndiName, DLA, expiryAddress, maxSize, pageSize, maxDeliveryAttempts, redeliveryDelay, lastValueQueue, redistributionDelay, sendToDLAOnNoRoute, addressFullMessagePolicy);
                }
            }
        }
        catch (Exception e) {
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage(e.getMessage());
            e.printStackTrace();
        }
        return createResourceReport;
    }

    @Override
    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        this.jmsComponent = this;
    }

    @Override
    public void stop() {
        this.resourceContext = null;
    }

    private void createConnectionFactory(CreateResourceReport createResourceReport, ManagementView managementView, String name, String connectorNames, boolean ha, boolean useDiscovery, int cfType, String bindings, String clientId, int dupsOkBatchSize, int transactionBatchSize, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, int consumerWindowSize, int confirmationWindowSize, int producerMaxRate, int producerWindowSize, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean blockOnNonDurableSend, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean autoGroup, boolean preAcknowledge, long maxRetryInterval, double retryIntervalMultiplier, int reconnectAttempts, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, String groupId, int initialMessagePacketSize, boolean useGlobalPools, long retryInterval, String connectionLoadBalancingPolicyClassName) throws Exception {
        ManagedOperation operation = ManagementSupport.getOperation(managementView, "JMSConnectionFactoryManageMO", "createConnectionFactory", JMSConstants.ConnectionFactory.COMPONENT_TYPE);
        operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)name)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(ha)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(useDiscovery)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(cfType)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)connectorNames)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)bindings)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)clientId)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(dupsOkBatchSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(transactionBatchSize)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(clientFailureCheckPeriod)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(connectionTTL)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(callTimeout)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(consumerWindowSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(confirmationWindowSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(producerMaxRate)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(producerWindowSize)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(cacheLargeMessageClient)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(minLargeMessageSize)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(blockOnNonDurableSend)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(blockOnAcknowledge)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(blockOnDurableSend)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(autoGroup)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(preAcknowledge)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(maxRetryInterval)), new SimpleValueSupport(SimpleMetaType.DOUBLE_PRIMITIVE, (Serializable)Double.valueOf(retryIntervalMultiplier)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(reconnectAttempts)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(scheduledThreadPoolMaxSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(threadPoolMaxSize)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)groupId)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(initialMessagePacketSize)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(useGlobalPools)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(retryInterval)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)connectionLoadBalancingPolicyClassName))});
        createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
        createResourceReport.setResourceKey(name);
        createResourceReport.setResourceName(name);
    }

    private void createQueue(CreateResourceReport createResourceReport, ManagementView managementView, String name, String jndiName, String DLA, String expiryAddress, int maxSize, int pageSize, int maxDeliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy) throws Exception {
        ManagedOperation operation = ManagementSupport.getOperation(managementView, "JMSQueueManageMO", "createQueue", JMSConstants.Queue.COMPONENT_TYPE);
        StringBuffer sendRoles = new StringBuffer();
        StringBuffer consumeRoles = new StringBuffer();
        this.createRoles(createResourceReport, name, sendRoles, consumeRoles);
        operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)name)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)jndiName)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)DLA)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)expiryAddress)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(pageSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxDeliveryAttempts)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redeliveryDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(lastValueQueue)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redistributionDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(sendToDLAOnNoRoute)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressFullMessagePolicy)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)sendRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)consumeRoles.toString()))});
        createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
        createResourceReport.setResourceKey("jms.queue." + name);
        createResourceReport.setResourceName("jms.queue." + name);
    }

    private void createTopic(CreateResourceReport createResourceReport, ManagementView managementView, String name, String jndiName, String DLA, String expiryAddress, int maxSize, int pageSize, int maxDeliveryAttempts, long redeliveryDelay, boolean lastValueQueue, long redistributionDelay, boolean sendToDLAOnNoRoute, String addressFullMessagePolicy) throws Exception {
        ManagedOperation operation = ManagementSupport.getOperation(managementView, "JMSTopicManageMO", "createTopic", JMSConstants.Topic.COMPONENT_TYPE);
        StringBuffer sendRoles = new StringBuffer();
        StringBuffer consumeRoles = new StringBuffer();
        StringBuffer createNonDurableRoles = new StringBuffer();
        StringBuffer deleteNonDurableRoles = new StringBuffer();
        StringBuffer createDurableRoles = new StringBuffer();
        StringBuffer deleteDurableRoles = new StringBuffer();
        this.createRoles(createResourceReport, name, sendRoles, consumeRoles, createNonDurableRoles, deleteNonDurableRoles, createDurableRoles, deleteDurableRoles);
        operation.invoke(new MetaValue[]{new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)name)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)jndiName)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)DLA)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)expiryAddress)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(pageSize)), new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(maxDeliveryAttempts)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redeliveryDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(lastValueQueue)), new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(redistributionDelay)), new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(sendToDLAOnNoRoute)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressFullMessagePolicy)), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)sendRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)consumeRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)createDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)deleteDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)createNonDurableRoles.toString())), new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)deleteNonDurableRoles.toString()))});
        createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
        createResourceReport.setResourceKey("jms.topic." + name);
        createResourceReport.setResourceName("jms.topic." + name);
    }

    @Override
    public AvailabilityType getAvailability() {
        return AvailabilityType.UP;
    }

    @Override
    public ManagementView getProfileService() throws Exception {
        ResourceComponent component = this.resourceContext.getParentResourceComponent();
        Method m = component.getClass().getMethod("getConnection", new Class[0]);
        Object conn = m.invoke((Object)component, new Object[0]);
        m = conn.getClass().getMethod("getManagementView", new Class[0]);
        return (ManagementView)m.invoke(conn, new Object[0]);
    }

    @Override
    protected String getInvokeOperationSubscriptionMessage() {
        return null;
    }

    @Override
    protected String getInvokeOperationJMSMessage() {
        return null;
    }

    @Override
    protected String getInvokeOperation() {
        return "invokeManagerOperation";
    }

    @Override
    String getComponentName() {
        return "JMSServerMO";
    }

    @Override
    ComponentType getComponentType() {
        return JMSConstants.Manager.COMPONENT_TYPE;
    }

    @Override
    String getConfigurationOperationName() {
        return null;
    }

    @Override
    String getMeasurementsOperationName() {
        return null;
    }

    @Override
    String getDeleteOperationName() {
        return null;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport configurationUpdateReport) {
    }

    private void createRoles(CreateResourceReport configurationUpdateReport, String name, StringBuffer sendRoles, StringBuffer consumeRoles) {
        PropertyList propertyList = (PropertyList)configurationUpdateReport.getResourceConfiguration().get("roles");
        List roles = propertyList.getList();
        for (Property role : roles) {
            PropertyMap actRole = (PropertyMap)role;
            PropertySimple simple = (PropertySimple)actRole.get("name");
            name = simple.getStringValue();
            simple = (PropertySimple)actRole.get("send");
            boolean send = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("consume");
            boolean consume = simple.getBooleanValue();
            if (send) {
                if (sendRoles.length() > 0) {
                    sendRoles.append(",");
                }
                sendRoles.append(name);
            }
            if (!consume) continue;
            if (consumeRoles.length() > 0) {
                consumeRoles.append(",");
            }
            consumeRoles.append(name);
        }
    }

    private void createRoles(CreateResourceReport configurationUpdateReport, String name, StringBuffer sendRoles, StringBuffer consumeRoles, StringBuffer createNonDurableRoles, StringBuffer deleteNonDurableRoles, StringBuffer createDurableRoles, StringBuffer deleteDurableRoles) {
        PropertyList propertyList = (PropertyList)configurationUpdateReport.getResourceConfiguration().get("roles");
        List roles = propertyList.getList();
        for (Property role : roles) {
            PropertyMap actRole = (PropertyMap)role;
            PropertySimple simple = (PropertySimple)actRole.get("name");
            name = simple.getStringValue();
            simple = (PropertySimple)actRole.get("send");
            boolean send = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("consume");
            boolean consume = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("createNonDurableQueue");
            boolean createNonDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("deleteNonDurableQueue");
            boolean deleteNonDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("createDurableQueue");
            boolean createDurableQueue = simple.getBooleanValue();
            simple = (PropertySimple)actRole.get("deleteDurableQueue");
            boolean deleteDurableQueue = simple.getBooleanValue();
            if (send) {
                if (sendRoles.length() > 0) {
                    sendRoles.append(",");
                }
                sendRoles.append(name);
            }
            if (consume) {
                if (consumeRoles.length() > 0) {
                    consumeRoles.append(",");
                }
                consumeRoles.append(name);
            }
            if (createDurableQueue) {
                if (createDurableRoles.length() > 0) {
                    createDurableRoles.append(",");
                }
                createDurableRoles.append(name);
            }
            if (deleteDurableQueue) {
                if (deleteDurableRoles.length() > 0) {
                    deleteDurableRoles.append(",");
                }
                deleteDurableRoles.append(name);
            }
            if (createNonDurableQueue) {
                if (createNonDurableRoles.length() > 0) {
                    createNonDurableRoles.append(",");
                }
                createNonDurableRoles.append(name);
            }
            if (!deleteNonDurableQueue) continue;
            if (deleteNonDurableRoles.length() > 0) {
                deleteNonDurableRoles.append(",");
            }
            deleteNonDurableRoles.append(name);
        }
    }
}

