/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.bytecode;

import javassist.bytecode.Bytecode;

public class Boxing {
    public static void boxIfNessesary(Bytecode b, String desc) {
        if (desc.length() == 1) {
            char type = desc.charAt(0);
            switch (type) {
                case 'I': {
                    Boxing.boxInt(b);
                    break;
                }
                case 'J': {
                    Boxing.boxLong(b);
                    break;
                }
                case 'S': {
                    Boxing.boxShort(b);
                    break;
                }
                case 'F': {
                    Boxing.boxFloat(b);
                    break;
                }
                case 'D': {
                    Boxing.boxDouble(b);
                    break;
                }
                case 'B': {
                    Boxing.boxByte(b);
                    break;
                }
                case 'C': {
                    Boxing.boxChar(b);
                    break;
                }
                case 'Z': {
                    Boxing.boxBoolean(b);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot box unkown primitive type: " + type);
                }
            }
        }
    }

    public static Bytecode unbox(Bytecode b, String desc) {
        char type = desc.charAt(0);
        switch (type) {
            case 'I': {
                return Boxing.unboxInt(b);
            }
            case 'J': {
                return Boxing.unboxLong(b);
            }
            case 'S': {
                return Boxing.unboxShort(b);
            }
            case 'F': {
                return Boxing.unboxFloat(b);
            }
            case 'D': {
                return Boxing.unboxDouble(b);
            }
            case 'B': {
                return Boxing.unboxByte(b);
            }
            case 'C': {
                return Boxing.unboxChar(b);
            }
            case 'Z': {
                return Boxing.unboxBoolean(b);
            }
        }
        throw new RuntimeException("Cannot unbox unkown primitive type: " + type);
    }

    public static void boxInt(Bytecode bc) {
        bc.addInvokestatic("java.lang.Integer", "valueOf", "(I)Ljava/lang/Integer;");
    }

    public static void boxLong(Bytecode bc) {
        bc.addInvokestatic("java.lang.Long", "valueOf", "(J)Ljava/lang/Long;");
    }

    public static void boxShort(Bytecode bc) {
        bc.addInvokestatic("java.lang.Short", "valueOf", "(S)Ljava/lang/Short;");
    }

    public static void boxByte(Bytecode bc) {
        bc.addInvokestatic("java.lang.Byte", "valueOf", "(B)Ljava/lang/Byte;");
    }

    public static void boxFloat(Bytecode bc) {
        bc.addInvokestatic("java.lang.Float", "valueOf", "(F)Ljava/lang/Float;");
    }

    public static void boxDouble(Bytecode bc) {
        bc.addInvokestatic("java.lang.Double", "valueOf", "(D)Ljava/lang/Double;");
    }

    public static void boxChar(Bytecode bc) {
        bc.addInvokestatic("java.lang.Character", "valueOf", "(C)Ljava/lang/Character;");
    }

    public static void boxBoolean(Bytecode bc) {
        bc.addInvokestatic("java.lang.Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
    }

    public static Bytecode unboxInt(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "intValue", "()I");
        return bc;
    }

    public static Bytecode unboxLong(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "longValue", "()J");
        return bc;
    }

    public static Bytecode unboxShort(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "shortValue", "()S");
        return bc;
    }

    public static Bytecode unboxByte(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "byteValue", "()B");
        return bc;
    }

    public static Bytecode unboxFloat(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "floatValue", "()F");
        return bc;
    }

    public static Bytecode unboxDouble(Bytecode bc) {
        bc.addCheckcast("java.lang.Number");
        bc.addInvokevirtual("java.lang.Number", "doubleValue", "()D");
        return bc;
    }

    public static Bytecode unboxChar(Bytecode bc) {
        bc.addCheckcast("java.lang.Character");
        bc.addInvokevirtual("java.lang.Character", "charValue", "()C");
        return bc;
    }

    public static Bytecode unboxBoolean(Bytecode bc) {
        bc.addCheckcast("java.lang.Boolean");
        bc.addInvokevirtual("java.lang.Boolean", "booleanValue", "()Z");
        return bc;
    }
}

