/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.builtin;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFacade<T, X> {
    private final BeanManagerImpl beanManager;
    private final InjectionPoint injectionPoint;
    private final Type type;
    private final Annotation[] qualifiers;
    private final CreationalContext<? super T> creationalContext;

    protected static Type getFacadeType(InjectionPoint injectionPoint) {
        Type genericType = injectionPoint.getType();
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        throw new IllegalStateException(BeanMessage.TYPE_PARAMETER_MUST_BE_CONCRETE, injectionPoint);
    }

    protected AbstractFacade(Type type, Annotation[] qualifiers, InjectionPoint injectionPoint, CreationalContext<? super T> creationalContext, BeanManagerImpl beanManager) {
        this.beanManager = beanManager;
        this.injectionPoint = injectionPoint;
        this.creationalContext = creationalContext;
        this.type = type;
        this.qualifiers = qualifiers;
    }

    protected BeanManagerImpl getBeanManager() {
        return this.beanManager.getCurrent();
    }

    protected Annotation[] getQualifiers() {
        return this.qualifiers;
    }

    protected Type getType() {
        return this.type;
    }

    protected InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    protected CreationalContext<? super T> getCreationalContext() {
        return this.creationalContext;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractFacade) {
            AbstractFacade that = (AbstractFacade)obj;
            return this.getType().equals(that.getType()) && Arrays.equals(this.getQualifiers(), that.getQualifiers());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode += this.getType().hashCode() * 5;
        return hashCode += Arrays.hashCode(this.getQualifiers()) * 7;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AbstractFacadeSerializationProxy<T, X>
    implements Serializable {
        private static final long serialVersionUID = -9118965837530101152L;
        private final InjectionPoint injectionPoint;
        private final CreationalContext<? super T> creationalContext;
        private final BeanManagerImpl beanManager;

        protected AbstractFacadeSerializationProxy(AbstractFacade<T, X> facade) {
            this.injectionPoint = facade.getInjectionPoint();
            this.beanManager = facade.getBeanManager();
            this.creationalContext = facade.getCreationalContext();
        }

        protected BeanManagerImpl getBeanManager() {
            return this.beanManager;
        }

        protected InjectionPoint getInjectionPoint() {
            return this.injectionPoint;
        }

        protected CreationalContext<? super T> getCreationalContext() {
            return this.creationalContext;
        }
    }
}

