/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.web.tomcat.service.deployers.TomcatDeployer;
import org.jboss.web.tomcat.service.session.AskSessionOutdatedSessionChecker;
import org.jboss.web.tomcat.service.session.AttributeBasedClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteredSessionValve;
import org.jboss.web.tomcat.service.session.InstantSnapshotManager;
import org.jboss.web.tomcat.service.session.IntervalSnapshotManager;
import org.jboss.web.tomcat.service.session.JBossCacheManagerMBean;
import org.jboss.web.tomcat.service.session.JBossManager;
import org.jboss.web.tomcat.service.session.JvmRouteValve;
import org.jboss.web.tomcat.service.session.LockingValve;
import org.jboss.web.tomcat.service.session.OutdatedSessionChecker;
import org.jboss.web.tomcat.service.session.OwnedSessionUpdate;
import org.jboss.web.tomcat.service.session.SessionBasedClusteredSession;
import org.jboss.web.tomcat.service.session.SessionInvalidationTracker;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.Util;
import org.jboss.web.tomcat.service.session.distributedcache.spi.BatchingManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSessionMetadata;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.IncomingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingSessionGranularitySessionData;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationCapability;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationCause;
import org.jboss.web.tomcat.service.session.notification.ClusteredSessionNotificationPolicy;
import org.jboss.web.tomcat.service.session.notification.IgnoreUndeployLegacyClusteredSessionNotificationPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheManager<O extends OutgoingDistributableSessionData>
extends JBossManager
implements JBossCacheManagerMBean,
LocalDistributableSessionManager,
ClusteredManager<O>,
NotificationListener,
LifecycleListener {
    private static final String info_ = "JBossCacheManager/1.0";
    private static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    private static final DistributedCacheManagerFactory defaultFactory = JBossCacheManager.findDefaultFactory();
    private BatchingManager batchingManager;
    private DistributedCacheManager<O> proxy_;
    private final DistributedCacheManagerFactory distributedCacheManagerFactory;
    private Map<String, OwnedSessionUpdate> unloadedSessions_ = new ConcurrentHashMap<String, OwnedSessionUpdate>();
    private final ConcurrentMap<String, ClusteredSession<? extends OutgoingDistributableSessionData>> embryonicSessions = new ConcurrentHashMap<String, ClusteredSession<? extends OutgoingDistributableSessionData>>();
    private AtomicInteger passivatedCount_ = new AtomicInteger();
    private AtomicInteger maxPassivatedCount_ = new AtomicInteger();
    private Boolean useJK_;
    private boolean embedded_ = false;
    private SnapshotMode snapshotMode_ = null;
    private int snapshotInterval_ = 0;
    private ReplicationGranularity replicationGranularity_;
    private ReplicationTrigger replicationTrigger_;
    private Boolean replicationFieldBatchMode_;
    private ClassLoader tcl_;
    private SnapshotManager snapshotManager_;
    private String cacheConfigName_;
    private int maxUnreplicatedInterval_ = -1;
    private String notificationPolicyClass_;
    private ClusteredSessionNotificationPolicy notificationPolicy_;
    private ReplicationConfig replicationConfig_;
    private Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private Lock valveLock = new SemaphoreLock(this.semaphore);
    private OutdatedSessionChecker outdatedSessionChecker;
    private volatile boolean stopping;

    private static DistributedCacheManagerFactory findDefaultFactory() {
        Iterator<DistributedCacheManagerFactory> i$ = ServiceLoader.load(DistributedCacheManagerFactory.class, DistributedCacheManagerFactory.class.getClassLoader()).iterator();
        if (i$.hasNext()) {
            DistributedCacheManagerFactory factory = i$.next();
            return factory;
        }
        return null;
    }

    public JBossCacheManager() {
        this(defaultFactory);
    }

    public JBossCacheManager(DistributedCacheManagerFactory factory) {
        this.distributedCacheManagerFactory = factory;
    }

    @Override
    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        Boolean batch;
        if (this.distributedCacheManagerFactory == null) {
            throw new ClusteringNotSupportedException("No DistributedCacheManagerFactory service provider found.");
        }
        super.init(name, webMetaData);
        this.replicationConfig_ = webMetaData.getReplicationConfig();
        this.replicationTrigger_ = this.replicationConfig_.getReplicationTrigger();
        this.setReplicationGranularity(this.replicationConfig_.getReplicationGranularity());
        Boolean jk = this.replicationConfig_.getUseJK();
        if (jk != null) {
            this.useJK_ = jk;
        }
        this.replicationFieldBatchMode_ = (batch = this.replicationConfig_.getReplicationFieldBatchMode()) == null ? Boolean.TRUE : batch;
        this.setSnapshotMode(this.replicationConfig_.getSnapshotMode());
        Integer snapshotInt = this.replicationConfig_.getSnapshotInterval();
        this.setSnapshotInterval(snapshotInt == null ? 0 : snapshotInt);
        Integer maxUnrep = this.replicationConfig_.getMaxUnreplicatedInterval();
        if (maxUnrep != null) {
            this.maxUnreplicatedInterval_ = maxUnrep;
        }
        this.log_.debug((Object)("init(): replicationGranularity_ is " + this.replicationGranularity_ + " and replicationTrigger is " + this.replicationTrigger_ + " and replicationFieldBatchMode is " + this.replicationFieldBatchMode_ + " and useJK is " + this.useJK_ + " and snapshotMode is " + this.snapshotMode_ + " and snapshotInterval is " + this.snapshotInterval_));
        this.cacheConfigName_ = this.replicationConfig_.getCacheName();
        this.notificationPolicyClass_ = this.replicationConfig_.getSessionNotificationPolicy();
        this.initDistributedCacheManager();
        this.embedded_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocal(Session session) {
        ClusteredSession<OutgoingDistributableSessionData> clusterSess;
        ClusteredSession<OutgoingDistributableSessionData> clusteredSession = clusterSess = JBossCacheManager.uncheckedCastSession(session);
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from local store with id: " + realId));
            }
            try {
                clusterSess.removeMyselfLocal();
            }
            finally {
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeSession(Session baseSession) {
        boolean stored = false;
        if (baseSession != null && this.started_) {
            ClusteredSession<OutgoingDistributableSessionData> session;
            ClusteredSession<OutgoingDistributableSessionData> clusteredSession = session = JBossCacheManager.uncheckedCastSession(baseSession);
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("check to see if needs to store and replicate session with id " + session.getIdInternal()));
                }
                if (session.isValid() && (session.isSessionDirty() || session.getMustReplicateTimestamp())) {
                    String realId = session.getRealId();
                    long begin = System.currentTimeMillis();
                    session.notifyWillPassivate(ClusteredSessionNotificationCause.REPLICATION);
                    long elapsed = System.currentTimeMillis() - begin;
                    this.stats_.updatePassivationStats(realId, elapsed);
                    begin = System.currentTimeMillis();
                    this.processSessionRepl(session);
                    elapsed = System.currentTimeMillis() - begin;
                    stored = true;
                    this.stats_.updateReplicationStats(realId, elapsed);
                } else if (this.trace_) {
                    this.log_.trace((Object)("Session " + session.getIdInternal() + " did not require replication."));
                }
            }
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Session session) {
        block10: {
            if (session == null) {
                return;
            }
            if (!(session instanceof ClusteredSession)) {
                throw new IllegalArgumentException("You can only add instances of type ClusteredSession to this Manager. Session class name: " + session.getClass().getName());
            }
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        this.add(JBossCacheManager.uncheckedCastSession(session), false);
                        break block10;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                if (this.trace_) {
                    this.log_.trace((Object)"add(): ignoring add -- Manager is not actively handling requests");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void changeSessionId(Session session) {
        session.setId(this.getNextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createEmptySession() {
        ClusteredSession<OutgoingDistributableSessionData> session;
        block9: {
            session = null;
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        if (this.trace_) {
                            this.log_.trace((Object)"Creating an empty ClusteredSession");
                        }
                        session = this.createEmptyClusteredSession();
                        break block9;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                if (this.trace_) {
                    this.log_.trace((Object)"createEmptySession(): Manager is not handling requests; returning null");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return session;
    }

    public Session createSession() {
        return this.createSession(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session createSession(String sessionId) {
        Session session;
        block8: {
            session = null;
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (inLockingValve || this.valveLock.tryLock(0L, TimeUnit.SECONDS)) {
                    try {
                        session = this.createSessionInternal(sessionId);
                        break block8;
                    }
                    finally {
                        if (!inLockingValve) {
                            this.valveLock.unlock();
                        }
                    }
                }
                if (this.trace_) {
                    this.log_.trace((Object)"createEmptySession(): Manager is not handling requests; returning null");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return session;
    }

    private Session createSessionInternal(String sessionId) {
        ClusteredSession<OutgoingDistributableSessionData> session;
        if (this.maxActiveAllowed_ != -1 && this.calcActiveSessions() >= this.maxActiveAllowed_) {
            if (this.trace_) {
                this.log_.trace((Object)("createSession(): active sessions = " + this.calcActiveSessions() + " and max allowed sessions = " + this.maxActiveAllowed_));
            }
            this.processExpirationPassivation();
            if (this.calcActiveSessions() >= this.maxActiveAllowed_) {
                this.rejectedCounter_.incrementAndGet();
                String msgEnd = sessionId == null ? "" : " id " + sessionId;
                throw new IllegalStateException("createSession(): number of active sessions exceeds the maximum limit: " + this.maxActiveAllowed_ + " when trying to create session" + msgEnd);
            }
        }
        if ((session = this.createEmptyClusteredSession()) != null) {
            session.setNew(true);
            session.setCreationTime(System.currentTimeMillis());
            session.setMaxInactiveInterval(this.maxInactiveInterval_);
            session.setValid(true);
            String clearInvalidated = null;
            if (sessionId == null) {
                sessionId = this.getNextId();
                String jvmRoute = this.getJvmRoute();
                if (this.getUseJK() && jvmRoute != null) {
                    if (this.trace_) {
                        this.log_.trace((Object)("createSession(): useJK is true. Will append JvmRoute: " + jvmRoute));
                    }
                    sessionId = sessionId + "." + jvmRoute;
                }
            } else {
                clearInvalidated = sessionId;
            }
            session.setId(sessionId);
            this.getDistributedCacheManager().sessionCreated(session.getRealId());
            session.tellNew(ClusteredSessionNotificationCause.CREATE);
            if (this.trace_) {
                this.log_.trace((Object)("Created a ClusteredSession with id: " + sessionId));
            }
            this.createdCounter_.incrementAndGet();
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
            if (clearInvalidated != null) {
                SessionInvalidationTracker.clearInvalidatedSession(clearInvalidated, this);
            }
        }
        return session;
    }

    public Session findSession(String id) {
        String realId = this.getRealId(id);
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session == null && !SessionInvalidationTracker.isSessionInvalidated(realId, this)) {
            if (this.trace_) {
                this.log_.trace((Object)("Checking for session " + realId + " in the distributed cache"));
            }
            session = this.loadSession(realId);
        } else if (session != null && this.outdatedSessionChecker.isSessionOutdated(session)) {
            if (this.trace_) {
                this.log_.trace((Object)("Updating session " + realId + " from the distributed cache"));
            }
            if ((session = this.loadSession(realId)) == null) {
                this.sessions_.remove(realId);
            }
        }
        if (session != null) {
            SessionReplicationContext.bindSession(session, this.snapshotManager_);
            if (session.getNeedsPostReplicateActivation()) {
                session.notifyDidActivate(ClusteredSessionNotificationCause.REPLICATION);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] findSessions() {
        ClusteredSession<? extends OutgoingDistributableSessionData>[] sessions;
        block9: {
            sessions = null;
            try {
                boolean inLockingValve = SessionReplicationContext.isLocallyActive();
                if (!inLockingValve && !this.valveLock.tryLock(0L, TimeUnit.SECONDS)) break block9;
                try {
                    if (this.unloadedSessions_.size() > 0) {
                        HashSet<String> ids = new HashSet<String>(this.unloadedSessions_.keySet());
                        if (this.trace_) {
                            this.log_.trace((Object)("findSessions: loading sessions from distributed cache: " + ids));
                        }
                        for (String id : ids) {
                            this.loadSession(id);
                        }
                    }
                    sessions = this.findLocalSessions();
                }
                finally {
                    if (!inLockingValve) {
                        this.valveLock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return sessions;
    }

    public String getInfo() {
        return info_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Session session) {
        ClusteredSession<OutgoingDistributableSessionData> clusterSess;
        ClusteredSession<OutgoingDistributableSessionData> clusteredSession = clusterSess = JBossCacheManager.uncheckedCastSession(session);
        synchronized (clusteredSession) {
            String realId = clusterSess.getRealId();
            if (realId == null) {
                return;
            }
            if (this.trace_) {
                this.log_.trace((Object)("Removing session from store with id: " + realId));
            }
            try {
                clusterSess.removeMyself();
            }
            finally {
                SessionReplicationContext.sessionExpired(clusterSess, realId, this.snapshotManager_);
                SessionInvalidationTracker.sessionInvalidated(realId, this);
                this.sessions_.remove(realId);
                this.stats_.removeStats(realId);
                int timeAlive = (int)((System.currentTimeMillis() - clusterSess.getCreationTimeInternal()) / 1000L);
                this.sessionExpired(timeAlive);
            }
        }
    }

    @Override
    public DistributedCacheManager<O> getDistributedCacheManager() {
        return this.proxy_;
    }

    @Override
    public int getMaxUnreplicatedInterval() {
        return this.maxUnreplicatedInterval_;
    }

    @Override
    public ClusteredSessionNotificationPolicy getNotificationPolicy() {
        return this.notificationPolicy_;
    }

    @Override
    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger_;
    }

    @Override
    public void start() throws LifecycleException {
        this.log_ = Logger.getLogger((String)(this.getClass().getName() + "." + this.getContainer().getName().replaceAll("/", "")));
        if (this.embedded_) {
            this.startEmbedded();
        } else {
            this.startUnembedded();
        }
        Container container = this.getContainer();
        if (container instanceof Lifecycle) {
            LifecycleListener[] listeners;
            Lifecycle lifecycle = (Lifecycle)container;
            for (LifecycleListener listener : listeners = lifecycle.findLifecycleListeners()) {
                lifecycle.removeLifecycleListener(listener);
            }
            lifecycle.addLifecycleListener((LifecycleListener)this);
            for (LifecycleListener listener : listeners) {
                lifecycle.addLifecycleListener(listener);
            }
        }
        try {
            MBeanServer server = this.getMBeanServer();
            if (server.isRegistered(TomcatDeployer.TOMCAT_SERVICE_NAME)) {
                server.addNotificationListener(TomcatDeployer.TOMCAT_SERVICE_NAME, this, null, null);
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        if (!this.semaphore.tryAcquire()) {
            this.log_.debug((Object)"Opening up LockingValve");
            this.semaphore.release(Integer.MAX_VALUE);
        } else {
            this.semaphore.release();
        }
        this.log_.debug((Object)"Started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws LifecycleException {
        if (!this.started_) {
            throw new IllegalStateException("Manager not started");
        }
        if (this.stopping) {
            return;
        }
        this.log_.debug((Object)"Stopping");
        this.stopping = true;
        this.backgroundProcessAllowed.set(false);
        AtomicBoolean atomicBoolean = this.backgroundProcessAllowed;
        synchronized (atomicBoolean) {
            if (this.trace_) {
                this.log_.trace((Object)"All background processing terminated");
            }
        }
        Container container = this.getContainer();
        if (container instanceof Lifecycle) {
            ((Lifecycle)container).removeLifecycleListener((LifecycleListener)this);
        }
        try {
            MBeanServer server = this.getMBeanServer();
            if (server.isRegistered(TomcatDeployer.TOMCAT_SERVICE_NAME)) {
                server.removeNotificationListener(TomcatDeployer.TOMCAT_SERVICE_NAME, this);
            }
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e);
        }
        if (this.semaphore.tryAcquire()) {
            try {
                this.log_.debug((Object)"Closing off LockingValve");
                this.semaphore.acquire(0x7FFFFFFE);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.semaphore.release();
                throw new LifecycleException((Throwable)e);
            }
        }
        this.stopExtensions();
        this.resetStats();
        this.lifecycle_.fireLifecycleEvent("before_stop", (Object)this);
        this.clearSessions();
        this.tcl_ = null;
        this.proxy_.stop();
        this.proxy_ = null;
        this.batchingManager = null;
        this.snapshotManager_.stop();
        this.sessions_.clear();
        this.unloadedSessions_.clear();
        this.passivatedCount_.set(0);
        this.started_ = false;
        this.lifecycle_.fireLifecycleEvent("after_stop", (Object)this);
        this.unregisterManagerMBean();
    }

    @Override
    public void expireSession(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session != null) {
            session.expire();
        }
    }

    @Override
    public String getCacheConfigName() {
        return this.cacheConfigName_;
    }

    @Override
    public String getCreationTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getCreationTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getCreationTime()).toString();
    }

    @Override
    public int getDuplicates() {
        return this.duplicates_.get();
    }

    @Override
    public void setDuplicates(int duplicates) {
        this.duplicates_.set(duplicates);
    }

    @Override
    public String getLastAccessedTime(String sessionId) {
        Session session = this.findSession(sessionId);
        if (session == null) {
            this.log_.info((Object)("getLastAccessedTime(): Session " + sessionId + " not found"));
            return "";
        }
        return new Date(session.getLastAccessedTime()).toString();
    }

    @Override
    public String getSessionAttribute(String sessionId, String key) {
        Object attr = null;
        ClusteredSession<OutgoingDistributableSessionData> session = JBossCacheManager.uncheckedCastSession(this.findSession(sessionId));
        if (session != null) {
            attr = session.getAttribute(key);
        }
        return attr == null ? null : attr.toString();
    }

    @Override
    public long getMaxPassivatedSessionCount() {
        return this.maxPassivatedCount_.get();
    }

    @Override
    public void setMaxUnreplicatedInterval(int maxUnreplicatedInterval) {
        this.maxUnreplicatedInterval_ = maxUnreplicatedInterval;
    }

    @Override
    public long getPassivatedSessionCount() {
        return this.passivatedCount_.get();
    }

    @Override
    public ReplicationGranularity getReplicationGranularity() {
        return this.replicationGranularity_;
    }

    @Override
    public int getSnapshotInterval() {
        return this.snapshotInterval_;
    }

    @Override
    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode_;
    }

    @Override
    public boolean getUseJK() {
        return this.useJK_ == null ? false : this.useJK_;
    }

    @Override
    public boolean isPassivationEnabled() {
        return this.passivationMode_ && this.proxy_.isPassivationEnabled();
    }

    public boolean getPassivationEnabled() {
        return this.isPassivationEnabled();
    }

    public Boolean isReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode_;
    }

    @Override
    public String listLocalSessionIds() {
        return this.reportSessionIds(this.sessions_.keySet());
    }

    @Override
    public String listSessionIds() {
        HashSet<String> ids = new HashSet<String>(this.sessions_.keySet());
        ids.addAll(this.unloadedSessions_.keySet());
        return this.reportSessionIds(ids);
    }

    public String getContextName() {
        return this.getContainer().getName();
    }

    public String getHostName() {
        return this.getContainer().getParent().getName();
    }

    public ClassLoader getApplicationClassLoader() {
        return this.tcl_;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteInvalidation(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.remove(realId);
        if (session == null) {
            if (this.unloadedSessions_.remove(realId) != null && this.trace_) {
                this.log_.trace((Object)("Removed entry for session " + realId + " from unloaded session map"));
            }
            this.stats_.removeStats(realId);
        } else {
            boolean notify = false;
            boolean localCall = false;
            boolean localOnly = true;
            ContextClassLoaderSwitcher.SwitchContext switcher = null;
            try {
                SessionInvalidationTracker.suspend();
                switcher = JBossCacheManager.getContextClassLoaderSwitcher().getSwitchContext();
                switcher.setClassLoader(this.tcl_);
                session.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.INVALIDATE);
            }
            finally {
                SessionInvalidationTracker.resume();
                this.stats_.removeStats(realId);
                if (switcher != null) {
                    switcher.reset();
                }
            }
        }
    }

    public void notifyLocalAttributeModification(String realId) {
        ClusteredSession session = (ClusteredSession)this.sessions_.get(realId);
        if (session != null) {
            session.sessionAttributesDirty();
        } else {
            this.log_.warn((Object)("Received local attribute notification for " + realId + " but session is not locally active"));
        }
    }

    public void sessionActivated() {
        int pc = this.passivatedCount_.decrementAndGet();
        if (pc < 0) {
            this.passivatedCount_.incrementAndGet();
        }
    }

    public boolean sessionChangedInDistributedCache(String realId, String dataOwner, int distributedVersion, long timestamp, DistributableSessionMetadata metadata) {
        boolean updated = true;
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session != null) {
            updated = session.setVersionFromDistributedCache(distributedVersion);
            if (updated && this.trace_) {
                this.log_.trace((Object)("session in-memory data is invalidated for id: " + realId + " new version: " + distributedVersion));
            }
        } else {
            int maxLife = metadata == null ? this.getMaxInactiveInterval() : metadata.getMaxInactiveInterval();
            OwnedSessionUpdate existing = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(dataOwner, timestamp, maxLife, false));
            if (existing == null) {
                this.calcActiveSessions();
                if (this.trace_) {
                    this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                }
            } else if (this.trace_) {
                this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
            }
        }
        return updated;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval_ = snapshotInterval;
    }

    public void setSnapshotMode(SnapshotMode snapshotMode) {
        this.snapshotMode_ = snapshotMode;
    }

    public void setSnapshotMode(String snapshotMode) {
        snapshotMode = snapshotMode == null ? null : snapshotMode.toUpperCase();
        this.setSnapshotMode(SnapshotMode.fromString((String)snapshotMode));
    }

    public void setUseJK(boolean useJK) {
        this.useJK_ = useJK;
    }

    public void setReplicationGranularity(ReplicationGranularity granularity) {
        if (granularity == ReplicationGranularity.FIELD) {
            throw new IllegalArgumentException("FIELD replication-granularity is no longer supported");
        }
        this.replicationGranularity_ = granularity;
    }

    public String getReplicationGranularityString() {
        return this.replicationGranularity_ == null ? null : this.replicationGranularity_.toString();
    }

    public void setReplicationGranularityString(String granularity) {
        this.setReplicationGranularity(granularity == null ? null : ReplicationGranularity.fromString((String)granularity.toUpperCase()));
    }

    public void setReplicationTrigger(ReplicationTrigger trigger) {
        this.replicationTrigger_ = trigger;
    }

    public String getReplicationTriggerString() {
        return this.replicationTrigger_ == null ? null : this.replicationTrigger_.toString();
    }

    public void setReplicationTriggerString(String trigger) {
        this.setReplicationTrigger(trigger == null ? null : ReplicationTrigger.fromString((String)trigger.toUpperCase()));
    }

    public void setReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode_ = replicationFieldBatchMode;
    }

    public String getSessionNotificationPolicyClass() {
        return this.notificationPolicyClass_;
    }

    public void setSessionNotificationPolicyClass(String notificationPolicyClass) {
        this.notificationPolicyClass_ = notificationPolicyClass;
    }

    protected void initDistributedCacheManager() throws ClusteringNotSupportedException {
        this.proxy_ = this.distributedCacheManagerFactory.getDistributedCacheManager((LocalDistributableSessionManager)this);
    }

    protected void initSnapshotManager() {
        String ctxPath = ((Context)this.container_).getPath();
        if (SnapshotMode.INSTANT == this.snapshotMode_) {
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else if (this.snapshotMode_ == null) {
            this.log_.warn((Object)"Snapshot mode must be 'instant' or 'interval' - using 'instant'");
            this.snapshotMode_ = SnapshotMode.INSTANT;
            this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
        } else {
            if (ReplicationGranularity.FIELD == this.replicationGranularity_) {
                throw new IllegalStateException("Property snapshotMode must be " + SnapshotMode.INTERVAL + " when FIELD granularity is used");
            }
            if (this.snapshotInterval_ < 1) {
                this.log_.warn((Object)"Snapshot mode set to 'interval' but snapshotInterval is < 1 using 'instant'");
                this.snapshotMode_ = SnapshotMode.INSTANT;
                this.snapshotManager_ = new InstantSnapshotManager(this, ctxPath);
            } else {
                this.snapshotManager_ = new IntervalSnapshotManager(this, ctxPath, this.snapshotInterval_);
            }
        }
        this.snapshotManager_.start();
    }

    protected SnapshotManager getSnapshotManager() {
        return this.snapshotManager_;
    }

    protected void setSnapshotManager(SnapshotManager manager) {
        this.snapshotManager_ = manager;
    }

    protected void installValves() {
        this.log_.debug((Object)"Adding LockingValve");
        this.installContextValve((Valve)new LockingValve(this.valveLock));
        if (this.useJK_ == null) {
            this.useJK_ = this.getJvmRoute() != null;
        }
        if (this.getUseJK()) {
            this.log_.debug((Object)"We are using JK for load-balancing. Adding JvmRouteValve.");
            this.installContextValve((Valve)new JvmRouteValve(this));
        }
        BatchingManager valveBM = null;
        if (this.replicationGranularity_ == ReplicationGranularity.FIELD && Boolean.TRUE.equals(this.replicationFieldBatchMode_)) {
            valveBM = this.batchingManager;
            this.log_.debug((Object)"Including transaction manager in ClusteredSessionValve to support batch replication.");
        }
        ClusteredSessionValve valve = new ClusteredSessionValve(this, valveBM);
        this.log_.debug((Object)"Adding ClusteredSessionValve");
        this.installContextValve((Valve)valve);
    }

    protected void initClusteredSessionNotificationPolicy() {
        if (this.notificationPolicyClass_ == null || this.notificationPolicyClass_.length() == 0) {
            this.notificationPolicyClass_ = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.web.clustered.session.notification.policy", IgnoreUndeployLegacyClusteredSessionNotificationPolicy.class.getName());
                }
            });
        }
        try {
            this.notificationPolicy_ = (ClusteredSessionNotificationPolicy)Thread.currentThread().getContextClassLoader().loadClass(this.notificationPolicyClass_).newInstance();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + ClusteredSessionNotificationPolicy.class.getName() + " " + this.notificationPolicyClass_, e);
        }
        this.notificationPolicy_.setClusteredSessionNotificationCapability(new ClusteredSessionNotificationCapability());
    }

    protected OutdatedSessionChecker initOutdatedSessionChecker() {
        return new AskSessionOutdatedSessionChecker();
    }

    protected void initializeUnloadedSessions() {
        Map sessions = this.proxy_.getSessionIds();
        if (sessions != null) {
            String realId;
            boolean passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = this.passivationMinIdleTime_ * 1000L;
            for (Map.Entry entry : sessions.entrySet()) {
                realId = (String)entry.getKey();
                String owner = (String)entry.getValue();
                long ts = -1L;
                DistributableSessionMetadata md = null;
                try {
                    IncomingDistributableSessionData sessionData = this.proxy_.getSessionData(realId, owner, false);
                    if (sessionData == null) {
                        this.log_.debug((Object)("Metadata unavailable for unloaded session " + realId));
                        continue;
                    }
                    ts = sessionData.getTimestamp();
                    md = sessionData.getMetadata();
                }
                catch (Exception e) {
                    this.log_.debug((Object)("Problem reading metadata for session " + realId + " -- " + e.toString()), (Throwable)e);
                }
                long lastMod = ts == -1L ? System.currentTimeMillis() : ts;
                int maxLife = md == null ? this.getMaxInactiveInterval() : md.getMaxInactiveInterval();
                OwnedSessionUpdate osu = new OwnedSessionUpdate(owner, lastMod, maxLife, false);
                this.unloadedSessions_.put(realId, osu);
            }
            if (passivate) {
                for (Map.Entry<Object, Object> entry : this.unloadedSessions_.entrySet()) {
                    realId = (String)entry.getKey();
                    OwnedSessionUpdate osu = (OwnedSessionUpdate)entry.getValue();
                    try {
                        long elapsed = System.currentTimeMillis() - osu.getUpdateTime();
                        if (passivationMax >= 0L && elapsed > passivationMax) {
                            if (this.trace_) {
                                this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds max of " + passivationMax + "; passivating"));
                            }
                            this.processUnloadedSessionPassivation(realId, osu);
                            continue;
                        }
                        if (this.maxActiveAllowed_ <= 0 || passivationMin < 0L || this.calcActiveSessions() <= this.maxActiveAllowed_ || elapsed < passivationMin) continue;
                        if (this.trace_) {
                            this.log_.trace((Object)("Elapsed time of " + elapsed + " for session " + realId + " exceeds min of " + passivationMin + "; passivating"));
                        }
                        this.processUnloadedSessionPassivation(realId, osu);
                    }
                    catch (Exception e) {
                        this.log_.debug((Object)("Problem passivating session " + realId + " -- " + e.toString()));
                    }
                }
            }
        }
    }

    protected void startExtensions() {
    }

    protected void stopExtensions() {
    }

    @Override
    protected String getNextId() {
        String id;
        while (true) {
            if (this.sessions_.containsKey(id = super.getNextId()) || this.unloadedSessions_.containsKey(id)) {
                this.duplicates_.incrementAndGet();
                continue;
            }
            if (this.proxy_.isLocal(id)) break;
        }
        return id;
    }

    @Override
    protected int getTotalActiveSessions() {
        return this.localActiveCounter_.get() + this.unloadedSessions_.size() - this.passivatedCount_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processExpirationPassivation() {
        boolean passivate;
        block33: {
            boolean expire = this.maxInactiveInterval_ >= 0;
            passivate = this.isPassivationEnabled();
            long passivationMax = this.passivationMaxIdleTime_ * 1000L;
            long passivationMin = this.passivationMinIdleTime_ * 1000L;
            if (this.trace_) {
                this.log_.trace((Object)"processExpirationPassivation(): Looking for sessions that have expired ...");
                this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
                this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
                if (passivate) {
                    this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
                }
            }
            TreeSet<PassivationCheck> passivationChecks = new TreeSet<PassivationCheck>();
            try {
                SessionInvalidationTracker.suspend();
                ClusteredSession<? extends OutgoingDistributableSessionData>[] sessions = this.findLocalSessions();
                for (int i = 0; i < sessions.length; ++i) {
                    if (!this.backgroundProcessAllowed.get()) {
                        return;
                    }
                    boolean likelyExpired = false;
                    String realId = null;
                    try {
                        ClusteredSession<? extends OutgoingDistributableSessionData> session = sessions[i];
                        if (session == null) {
                            this.log_.warn((Object)("processExpirationPassivation(): processing null session at index " + i));
                            continue;
                        }
                        realId = session.getRealId();
                        likelyExpired = expire;
                        if (expire) {
                            boolean bl = likelyExpired = !session.isValid(false);
                            if (likelyExpired && this.outdatedSessionChecker.isSessionOutdated(session)) {
                                this.loadSession(session.getRealId());
                            }
                            if (!session.isValid()) continue;
                            likelyExpired = false;
                        }
                        if (!passivate) continue;
                        passivationChecks.add(new PassivationCheck(session));
                        continue;
                    }
                    catch (Exception ex) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, ex);
                            continue;
                        }
                        this.log_.error((Object)("processExpirationPassivation(): failed handling " + realId + " with exception: " + ex), (Throwable)ex);
                    }
                }
                if (!this.backgroundProcessAllowed.get()) {
                    return;
                }
                long maxUnrep = this.maxUnreplicatedInterval_ < 0 ? 60L : (long)this.maxUnreplicatedInterval_;
                Map<String, OwnedSessionUpdate> unloaded = this.getUnloadedSessions();
                for (Map.Entry<String, OwnedSessionUpdate> entry : unloaded.entrySet()) {
                    if (!this.backgroundProcessAllowed.get()) {
                        return;
                    }
                    String realId = entry.getKey();
                    OwnedSessionUpdate osu = entry.getValue();
                    boolean likelyExpired = false;
                    long now = System.currentTimeMillis();
                    long elapsed = now - osu.getUpdateTime();
                    try {
                        boolean bl = likelyExpired = expire && osu.getMaxInactive() >= 1 && elapsed >= ((long)osu.getMaxInactive() + maxUnrep) * 1000L;
                        if (likelyExpired) {
                            Session session;
                            if (osu.isPassivated() && (session = this.findSession(realId)) != null) {
                                session.isValid();
                                continue;
                            }
                            this.proxy_.removeSessionLocal(realId, osu.getOwner());
                            this.unloadedSessions_.remove(realId);
                            this.stats_.removeStats(realId);
                            continue;
                        }
                        if (!passivate || osu.isPassivated()) continue;
                        passivationChecks.add(new PassivationCheck(realId, osu));
                    }
                    catch (Exception ex) {
                        if (likelyExpired) {
                            this.bruteForceCleanup(realId, ex);
                            continue;
                        }
                        this.log_.error((Object)("processExpirationPassivation(): failed handling unloaded session " + realId), (Throwable)ex);
                    }
                }
                if (!passivate) break block33;
                for (PassivationCheck passivationCheck : passivationChecks) {
                    try {
                        long timeNow = System.currentTimeMillis();
                        long timeIdle = timeNow - passivationCheck.getLastUpdate();
                        if (passivationMax >= 0L && timeIdle > passivationMax) {
                            passivationCheck.passivate();
                            continue;
                        }
                        if (this.maxActiveAllowed_ > 0 && passivationMin > 0L && this.calcActiveSessions() >= this.maxActiveAllowed_ && timeIdle > passivationMin) {
                            passivationCheck.passivate();
                        }
                        break;
                    }
                    catch (Exception e) {
                        String unloadMark = passivationCheck.isUnloaded() ? "unloaded " : "";
                        this.log_.error((Object)("processExpirationPassivation(): failed passivating " + unloadMark + "session " + passivationCheck.getRealId()), (Throwable)e);
                    }
                }
            }
            catch (Exception ex) {
                this.log_.error((Object)("processExpirationPassivation(): failed with exception: " + ex), (Throwable)ex);
            }
            finally {
                SessionInvalidationTracker.resume();
            }
        }
        if (this.trace_) {
            this.log_.trace((Object)"processExpirationPassivation(): Completed ...");
            this.log_.trace((Object)("processExpirationPassivation(): active sessions = " + this.calcActiveSessions()));
            this.log_.trace((Object)("processExpirationPassivation(): expired sessions = " + this.expiredCounter_));
            if (passivate) {
                this.log_.trace((Object)("processExpirationPassivation(): passivated count = " + this.getPassivatedSessionCount()));
            }
        }
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.maxPassivatedCount_.set(this.passivatedCount_.get());
    }

    protected Map<String, OwnedSessionUpdate> getUnloadedSessions() {
        HashMap<String, OwnedSessionUpdate> unloaded = new HashMap<String, OwnedSessionUpdate>(this.unloadedSessions_);
        return unloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClusteredSession<? extends OutgoingDistributableSessionData> createEmptyClusteredSession() {
        void var1_5;
        Object var1_1 = null;
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve && !this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return var1_5;
            try {
                switch (this.replicationGranularity_) {
                    case ATTRIBUTE: {
                        JBossCacheManager<OutgoingAttributeGranularitySessionData> amgr = JBossCacheManager.uncheckedCastManager(this);
                        AttributeBasedClusteredSession attributeBasedClusteredSession = new AttributeBasedClusteredSession((ClusteredManager<OutgoingAttributeGranularitySessionData>)amgr);
                        return var1_5;
                    }
                    default: {
                        JBossCacheManager<OutgoingSessionGranularitySessionData> smgr = JBossCacheManager.uncheckedCastManager(this);
                        SessionBasedClusteredSession sessionBasedClusteredSession = new SessionBasedClusteredSession((ClusteredManager<OutgoingSessionGranularitySessionData>)smgr);
                        return var1_5;
                    }
                }
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return var1_5;
    }

    private void add(ClusteredSession<? extends OutgoingDistributableSessionData> session, boolean replicate) {
        if (!session.isValid()) {
            this.log_.debug((Object)("Cannot add session with id=" + session.getIdInternal() + " because it is invalid"));
            return;
        }
        String realId = session.getRealId();
        ClusteredSession<? extends OutgoingDistributableSessionData> existing = this.sessions_.put(realId, session);
        this.unloadedSessions_.remove(realId);
        if (!session.equals(existing)) {
            if (replicate) {
                this.storeSession(session);
            }
            this.calcActiveSessions();
            if (this.trace_) {
                this.log_.trace((Object)("Session with id=" + session.getIdInternal() + " added. " + "Current active sessions " + this.localActiveCounter_.get()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bruteForceCleanup(String realId, Exception ex) {
        this.log_.warn((Object)("Standard expiration of session " + realId + " failed; switching to a brute " + "force cleanup. Problem is" + ex.getLocalizedMessage()));
        try {
            this.proxy_.removeSessionLocal(realId, null);
        }
        catch (Exception e) {
            this.log_.error((Object)("processExpirationPassivation(): Caught exception during brute force cleanup of unloaded session " + realId + " session will be removed from Manager " + "but may still exist in distributed cache"), (Throwable)e);
        }
        finally {
            this.unloadedSessions_.remove(realId);
            this.stats_.removeStats(realId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClusteredSession<? extends OutgoingDistributableSessionData> loadSession(String realId) {
        if (realId == null) {
            return null;
        }
        ClusteredSession<OutgoingDistributableSessionData> session = null;
        try {
            boolean inLockingValve = SessionReplicationContext.isLocallyActive();
            if (!inLockingValve) {
                if (!this.valveLock.tryLock(0L, TimeUnit.SECONDS)) return session;
            }
            try {
                Object osu;
                long begin = System.currentTimeMillis();
                boolean mustAdd = false;
                boolean passivated = false;
                session = (ClusteredSession<OutgoingDistributableSessionData>)this.sessions_.get(realId);
                boolean initialLoad = false;
                if (session == null) {
                    initialLoad = true;
                    mustAdd = true;
                    session = this.createEmptyClusteredSession();
                    ClusteredSession<OutgoingDistributableSessionData> embryo = this.embryonicSessions.putIfAbsent(realId, session);
                    if (embryo != null) {
                        session = embryo;
                    }
                    passivated = (osu = this.unloadedSessions_.get(realId)) != null && ((OwnedSessionUpdate)osu).isPassivated();
                }
                ClusteredSession<OutgoingDistributableSessionData> clusteredSession = session;
                synchronized (clusteredSession) {
                    if (initialLoad && !session.isOutdated()) {
                        osu = session;
                        return osu;
                    }
                    IncomingDistributableSessionData data = this.proxy_.getSessionData(realId, initialLoad);
                    if (data != null) {
                        session.update(data);
                    } else {
                        session = null;
                    }
                    if (session != null) {
                        ClusteredSessionNotificationCause cause = passivated ? ClusteredSessionNotificationCause.ACTIVATION : ClusteredSessionNotificationCause.FAILOVER;
                        session.notifyDidActivate(cause);
                    }
                    if (session != null) {
                        if (mustAdd) {
                            this.add(session, false);
                            if (!passivated) {
                                session.tellNew(ClusteredSessionNotificationCause.FAILOVER);
                            }
                        }
                        long elapsed = System.currentTimeMillis() - begin;
                        this.stats_.updateLoadStats(realId, elapsed);
                        if (this.trace_) {
                            this.log_.trace((Object)("loadSession(): id= " + realId + ", session=" + session));
                        }
                    } else if (this.trace_) {
                        this.log_.trace((Object)("loadSession(): session " + realId + " not found in distributed cache"));
                    }
                    if (!initialLoad) return session;
                    this.embryonicSessions.remove(realId);
                    return session;
                }
            }
            finally {
                if (!inLockingValve) {
                    this.valveLock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return session;
    }

    private void processSessionRepl(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
        boolean notSession = this.replicationGranularity_ != ReplicationGranularity.SESSION;
        boolean doTx = false;
        try {
            if (notSession && !this.batchingManager.isBatchInProgress()) {
                this.batchingManager.startBatch();
                doTx = true;
            }
            session.processSessionReplication();
        }
        catch (Exception ex) {
            this.log_.debug((Object)"processSessionRepl(): failed with exception", (Throwable)ex);
            try {
                if (notSession) {
                    this.batchingManager.setBatchRollbackOnly();
                }
            }
            catch (Exception exn) {
                this.log_.error((Object)"Caught exception rolling back transaction", (Throwable)exn);
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException("JBossCacheManager.processSessionRepl(): failed to replicate session.", ex);
        }
        finally {
            if (doTx) {
                this.batchingManager.endBatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionPassivation(String realId) {
        ClusteredSession<? extends OutgoingDistributableSessionData> session = this.findLocalSession(realId);
        if (session != null) {
            ClusteredSession<? extends OutgoingDistributableSessionData> clusteredSession = session;
            synchronized (clusteredSession) {
                if (this.trace_) {
                    this.log_.trace((Object)("Passivating session with id: " + realId));
                }
                session.notifyWillPassivate(ClusteredSessionNotificationCause.PASSIVATION);
                this.proxy_.evictSession(realId);
                this.sessionPassivated();
                OwnedSessionUpdate obj = this.unloadedSessions_.put(realId, new OwnedSessionUpdate(null, session.getLastAccessedTimeInternal(), session.getMaxInactiveInterval(), true));
                if (this.trace_) {
                    if (obj == null) {
                        this.log_.trace((Object)("New session " + realId + " added to unloaded session map"));
                    } else {
                        this.log_.trace((Object)("Updated timestamp for unloaded session " + realId));
                    }
                }
                this.sessions_.remove(realId);
            }
        } else if (this.trace_) {
            this.log_.trace((Object)("processSessionPassivation():  could not find session " + realId));
        }
    }

    private void processUnloadedSessionPassivation(String realId, OwnedSessionUpdate osu) {
        if (this.trace_) {
            this.log_.trace((Object)("Passivating session with id: " + realId));
        }
        this.proxy_.evictSession(realId, osu.getOwner());
        osu.setPassivated(true);
        this.sessionPassivated();
    }

    private void sessionPassivated() {
        int pc = this.passivatedCount_.incrementAndGet();
        int max = this.maxPassivatedCount_.get();
        while (pc > max) {
            if (this.maxPassivatedCount_.compareAndSet(max, pc)) continue;
            max = this.maxPassivatedCount_.get();
        }
    }

    private void startUnembedded() throws LifecycleException {
        if (this.started_) {
            return;
        }
        this.log_.debug((Object)"Manager is about to start");
        this.lifecycle_.fireLifecycleEvent("before_start", (Object)this);
        this.configureUnembedded();
        this.initClusteredSessionNotificationPolicy();
        try {
            if (this.replicationConfig_ == null) {
                this.synthesizeReplicationConfig();
            }
            if (this.proxy_ == null) {
                this.initDistributedCacheManager();
            }
            this.tcl_ = this.container_.getLoader().getClassLoader();
            this.proxy_.start();
        }
        catch (Throwable t) {
            String str = "Problem starting DistributedCacheManager for HttpSession clustering";
            this.log_.error((Object)str, t);
            throw new LifecycleException(str, t);
        }
        this.batchingManager = this.proxy_.getBatchingManager();
        if (this.batchingManager == null) {
            throw new LifecycleException("start(): Obtained null batchingManager");
        }
        try {
            this.outdatedSessionChecker = this.initOutdatedSessionChecker();
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.backgroundProcessAllowed.set(true);
            this.started_ = true;
            this.lifecycle_.fireLifecycleEvent("after_start", (Object)this);
            this.startExtensions();
            this.log_.debug((Object)"start(): DistributedCacheManager started");
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
        this.registerManagerMBean();
    }

    protected void configureUnembedded() throws LifecycleException {
    }

    private void synthesizeReplicationConfig() {
        ReplicationConfig cfg = new ReplicationConfig();
        cfg.setReplicationGranularity(this.replicationGranularity_);
        cfg.setReplicationTrigger(this.replicationTrigger_);
        cfg.setUseJK(this.useJK_);
        cfg.setCacheName(this.cacheConfigName_);
        cfg.setSnapshotMode(this.snapshotMode_);
        cfg.setSnapshotInterval(Integer.valueOf(this.snapshotInterval_));
        cfg.setMaxUnreplicatedInterval(Integer.valueOf(this.maxUnreplicatedInterval_));
        cfg.setSessionNotificationPolicy(this.notificationPolicyClass_);
        this.replicationConfig_ = cfg;
    }

    private void installContextValve(Valve valve) {
        boolean installed = false;
        if (this.embedded_ && this.getContextObjectName() != null) {
            try {
                this.getMBeanServer().invoke(this.getContextObjectName(), "addValve", new Object[]{valve}, new String[]{"org.apache.catalina.Valve"});
                installed = true;
            }
            catch (Exception e) {
                this.log_.debug((Object)("Caught " + e.toString() + " when installing valve to Context, installing directly"));
            }
        }
        if (!installed) {
            if (this.container_ instanceof ContainerBase) {
                ((ContainerBase)this.container_).addValve(valve);
            } else {
                this.container_.getPipeline().addValve(valve);
            }
        }
    }

    private ObjectName getContextObjectName() {
        String oname = this.container_.getObjectName();
        try {
            return oname == null ? null : new ObjectName(oname);
        }
        catch (MalformedObjectNameException e) {
            this.log_.warn((Object)("Error creating object name from string " + oname), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSessions() {
        boolean passivation = this.isPassivationEnabled();
        ClusteredSession<? extends OutgoingDistributableSessionData>[] sessions = this.findLocalSessions();
        for (int i = 0; i < sessions.length; ++i) {
            ClusteredSession<? extends OutgoingDistributableSessionData> ses = sessions[i];
            if (this.trace_) {
                this.log_.trace((Object)("clearSessions(): clear session by expiring or passivating: " + ses));
            }
            try {
                if (passivation && ses.isValid()) {
                    this.processSessionPassivation(ses.getRealId());
                    continue;
                }
                boolean notify = true;
                boolean localCall = true;
                boolean localOnly = true;
                ses.expire(notify, localCall, localOnly, ClusteredSessionNotificationCause.UNDEPLOY);
                continue;
            }
            catch (Throwable t) {
                this.log_.warn((Object)("clearSessions(): Caught exception expiring or passivating session " + ses.getIdInternal()), t);
                continue;
            }
            finally {
                ses.recycle();
            }
        }
        String action = passivation ? "evicting" : "removing";
        Set<Map.Entry<String, OwnedSessionUpdate>> unloaded = this.unloadedSessions_.entrySet();
        Iterator<Map.Entry<String, OwnedSessionUpdate>> it = unloaded.iterator();
        while (it.hasNext()) {
            Map.Entry<String, OwnedSessionUpdate> entry = it.next();
            String realId = entry.getKey();
            try {
                if (passivation) {
                    OwnedSessionUpdate osu = entry.getValue();
                    if (!osu.isPassivated()) {
                        this.proxy_.evictSession(realId, osu.getOwner());
                    }
                } else {
                    this.proxy_.removeSessionLocal(realId);
                }
            }
            catch (Exception e) {
                this.log_.debug((Object)("Problem " + action + " session " + realId + " -- " + e));
            }
            it.remove();
        }
    }

    private void startEmbedded() throws LifecycleException {
        super.start();
        this.initClusteredSessionNotificationPolicy();
        this.outdatedSessionChecker = this.initOutdatedSessionChecker();
        this.tcl_ = super.getContainer().getLoader().getClassLoader();
        try {
            if (this.proxy_ == null) {
                this.initDistributedCacheManager();
            }
            this.proxy_.start();
            this.batchingManager = this.proxy_.getBatchingManager();
            if (this.batchingManager == null) {
                throw new LifecycleException("JBossCacheManager.start(): Obtain null batchingManager");
            }
            this.initializeUnloadedSessions();
            this.initSnapshotManager();
            this.installValves();
            this.startExtensions();
            this.log_.debug((Object)"start(): DistributedCacheManager started");
        }
        catch (LifecycleException le) {
            throw le;
        }
        catch (Exception e) {
            this.log_.error((Object)"Unable to start manager.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    private String getRealId(String id) {
        return this.getUseJK() ? Util.getRealId(id) : id;
    }

    private String reportSessionIds(Set<String> ids) {
        StringBuffer sb = new StringBuffer();
        boolean added = false;
        for (String id : ids) {
            if (added) {
                sb.append(',');
            } else {
                added = true;
            }
            sb.append(id);
        }
        return sb.toString();
    }

    private static ContextClassLoaderSwitcher getContextClassLoaderSwitcher() {
        return (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    }

    private static <T extends OutgoingDistributableSessionData> JBossCacheManager<T> uncheckedCastManager(JBossCacheManager<?> mgr) {
        return mgr;
    }

    private static ClusteredSession<? extends OutgoingDistributableSessionData> uncheckedCastSession(Session session) {
        return (ClusteredSession)session;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        this.handleForceSynchronousNotification(event.getType(), "before_stop", "after_stop");
    }

    @Override
    public void handleNotification(Notification notification, Object callback) {
        this.handleForceSynchronousNotification(notification.getType(), "jboss.tomcat.connectors.stopped", "jboss.tomcat.connectors.started");
    }

    private void handleForceSynchronousNotification(String type, String enableType, String disableType) {
        boolean enabled = type.equals(enableType);
        if ((enabled || type.equals(disableType)) && this.proxy_ != null) {
            this.proxy_.setForceSynchronous(enabled);
        }
    }

    @Override
    public String locate(String sessionId) {
        return this.proxy_.locate(sessionId);
    }

    public String getEngineName() {
        return this.getEngine().getName();
    }

    public int hashCode() {
        return 0;
    }

    private static class SemaphoreLock
    implements Lock {
        private final Semaphore semaphore;

        SemaphoreLock(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void lock() {
            this.semaphore.acquireUninterruptibly();
        }

        public void lockInterruptibly() throws InterruptedException {
            this.semaphore.acquire();
        }

        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }

        public boolean tryLock() {
            return this.semaphore.tryAcquire();
        }

        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            return this.semaphore.tryAcquire(timeout, unit);
        }

        public void unlock() {
            this.semaphore.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PassivationCheck
    implements Comparable<PassivationCheck> {
        private final String realId;
        private final OwnedSessionUpdate osu;
        private final ClusteredSession<? extends OutgoingDistributableSessionData> session;

        private PassivationCheck(String realId, OwnedSessionUpdate osu) {
            assert (osu != null) : "osu is null";
            assert (realId != null) : "realId is null";
            this.realId = realId;
            this.osu = osu;
            this.session = null;
        }

        private PassivationCheck(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
            assert (session != null) : "session is null";
            this.realId = session.getRealId();
            this.session = session;
            this.osu = null;
        }

        private long getLastUpdate() {
            return this.osu == null ? this.session.getLastAccessedTimeInternal() : this.osu.getUpdateTime();
        }

        private void passivate() {
            if (this.osu == null) {
                JBossCacheManager.this.processSessionPassivation(this.realId);
            } else {
                JBossCacheManager.this.processUnloadedSessionPassivation(this.realId, this.osu);
            }
        }

        private String getRealId() {
            return this.realId;
        }

        private boolean isUnloaded() {
            return this.osu != null;
        }

        @Override
        public int compareTo(PassivationCheck o) {
            long anotherVal;
            long thisVal = this.getLastUpdate();
            return thisVal < (anotherVal = o.getLastUpdate()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
    }
}

