/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.ondemand;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.http.mapper.OnDemandContextMappingListener;
import org.jboss.web.tomcat.service.ondemand.ContextDemandListener;
import org.jboss.web.tomcat.service.ondemand.OnDemandContextIntegrator;

public class DefaultOnDemandContextIntegrator
implements OnDemandContextIntegrator {
    private static final Logger log = Logger.getLogger(DefaultOnDemandContextIntegrator.class);
    private final Set<ContextDemandAdapter> adapters = Collections.synchronizedSet(new HashSet());
    private final Map<String, Mapper> mappers = Collections.synchronizedMap(new HashMap());

    public void registerMapper(String serviceName, Mapper mapper) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Argument serviceName is null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument mapper is null");
        }
        this.mappers.put(serviceName, mapper);
        ContextDemandAdapter adapter = new ContextDemandAdapter(serviceName);
        mapper.registerOnDemandContextMappingListener((OnDemandContextMappingListener)adapter);
        this.adapters.add(adapter);
    }

    public void registerContextDemandListener(ContextDemandListener listener) {
        for (ContextDemandAdapter adapter : this.adapters) {
            adapter.registerContextDemandListener(listener);
        }
    }

    public void removeContextDemandListener(ContextDemandListener listener) {
        for (ContextDemandAdapter adapter : this.adapters) {
            adapter.removeContextDemandListener(listener);
        }
    }

    public void registerOnDemandContext(String serviceName, String hostName, String contextName) {
        Mapper mapper = this.mappers.get(serviceName);
        if (mapper != null) {
            if (contextName.length() > 0 && '/' != contextName.charAt(0)) {
                contextName = "/" + contextName;
            }
            mapper.addOnDemandContext(hostName, contextName);
        } else {
            log.warn((Object)("Cannot register on-demand context for unknown engine " + serviceName));
        }
    }

    public void removeOnDemandContext(String serviceName, String hostName, String contextName) {
        Mapper mapper = this.mappers.get(serviceName);
        if (mapper != null) {
            mapper.removeContext(hostName, contextName);
        } else {
            log.warn((Object)("Cannot remove on-demand context for unknown engine " + serviceName));
        }
    }

    private class ContextDemandAdapter
    implements OnDemandContextMappingListener {
        private final String engineName;
        private final Set<ContextDemandListener> contextDemandListeners = Collections.synchronizedSet(new HashSet());

        private ContextDemandAdapter(String engineName) {
            this.engineName = engineName;
        }

        public void onDemandContextMapped(String hostName, String contextName) {
            for (ContextDemandListener listener : this.contextDemandListeners) {
                listener.contextDemanded(this.engineName, hostName, contextName);
            }
        }

        private void registerContextDemandListener(ContextDemandListener listener) {
            if (listener != null) {
                this.contextDemandListeners.add(listener);
            }
        }

        private void removeContextDemandListener(ContextDemandListener listener) {
            if (listener != null) {
                this.contextDemandListeners.remove(listener);
            }
        }
    }
}

