/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.login;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.servlet.http.Cookie;
import org.apache.catalina.Container;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.Constants;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.jboss.web.tomcat.service.request.ActiveRequestResponseCacheValve;

public class WebAuthentication {
    private static final String AUTH_TYPE = "PROGRAMMATIC_WEB_LOGIN";

    public boolean login(X509Certificate[] certs) {
        Request request = ActiveRequestResponseCacheValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        Principal p = request.getContext().getRealm().authenticate(certs);
        if (p != null) {
            this.register(request, p, null, null);
        }
        return p != null;
    }

    public boolean login(String username, Object credential) {
        Request request = ActiveRequestResponseCacheValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        Principal p = null;
        if (credential instanceof String) {
            p = request.getContext().getRealm().authenticate(username, (String)credential);
        } else if (credential instanceof byte[]) {
            p = request.getContext().getRealm().authenticate(username, (byte[])credential);
        }
        if (p != null) {
            this.register(request, p, username, credential);
        }
        return p != null;
    }

    public void logout() {
        Request request = ActiveRequestResponseCacheValve.activeRequest.get();
        if (request == null) {
            throw new IllegalStateException("request is null");
        }
        this.unregister(request);
    }

    protected void register(Request request, Principal principal, String username, Object password) {
        SingleSignOn sso;
        request.setAuthType(AUTH_TYPE);
        request.setUserPrincipal(principal);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(AUTH_TYPE);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", (Object)this.getPasswordAsString(password));
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if ((sso = this.getSingleSignOn(request)) == null) {
            return;
        }
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (ssoId == null) {
            ssoId = this.generateSessionId();
            Cookie cookie = new Cookie(Constants.SINGLE_SIGN_ON_COOKIE, ssoId);
            cookie.setMaxAge(-1);
            cookie.setPath("/");
            cookie.setSecure(request.isSecure());
            String ssoDomain = sso.getCookieDomain();
            if (ssoDomain != null) {
                cookie.setDomain(ssoDomain);
            }
            Response response = ActiveRequestResponseCacheValve.activeResponse.get();
            response.addCookie(cookie);
            sso.register(ssoId, principal, AUTH_TYPE, username, this.getPasswordAsString(password));
            request.setNote("org.apache.catalina.request.SSOID", (Object)ssoId);
        } else {
            sso.update(ssoId, principal, AUTH_TYPE, username, this.getPasswordAsString(password));
        }
        if (session == null) {
            session = request.getSessionInternal(true);
        }
        sso.associate(ssoId, session);
    }

    protected void unregister(Request request) {
        SingleSignOn sso;
        request.setAuthType(null);
        request.setUserPrincipal(null);
        Session session = request.getSessionInternal(false);
        if (session != null) {
            session.setAuthType(null);
            session.setPrincipal(null);
            session.removeNote("org.apache.catalina.session.USERNAME");
            session.removeNote("org.apache.catalina.session.PASSWORD");
        }
        if ((sso = this.getSingleSignOn(request)) != null) {
            String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
            sso.deregister(ssoId);
        }
    }

    private String getPasswordAsString(Object cred) {
        String p = null;
        if (cred instanceof String) {
            p = (String)cred;
        } else if (cred instanceof byte[]) {
            p = new String((byte[])cred);
        }
        return p;
    }

    private String generateSessionId() {
        UUID uid = UUID.randomUUID();
        String higherBits = Long.toHexString(uid.getMostSignificantBits());
        String lowerBits = Long.toHexString(uid.getLeastSignificantBits());
        return (higherBits + lowerBits).toUpperCase();
    }

    private SingleSignOn getSingleSignOn(Request request) {
        SingleSignOn sso = null;
        Container parent = request.getContext().getParent();
        while (sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        return sso;
    }
}

