/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.async;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.async.spi.AsyncEndpoint;
import org.jboss.ejb3.async.spi.AsyncUtil;
import org.jboss.ejb3.sis.Interceptor;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;

public class AsyncClientInterceptor
implements Interceptor {
    private static final Logger log = Logger.getLogger(AsyncClientInterceptor.class);
    private final AsyncEndpoint asyncEndpoint;
    private final AsyncMethodsMetaData asyncMethods;
    private final Serializable sessionId;

    public AsyncClientInterceptor(AsyncEndpoint asyncEndpoint, AsyncMethodsMetaData asyncMethods, Serializable sessionId) {
        if (asyncEndpoint == null) {
            throw new IllegalArgumentException("Endpoint must be specified");
        }
        if (asyncMethods == null) {
            throw new IllegalArgumentException("asyncMethods must be specified");
        }
        this.asyncEndpoint = asyncEndpoint;
        this.asyncMethods = asyncMethods;
        this.sessionId = sessionId;
    }

    public Object invoke(InvocationContext context) throws Exception {
        if (this.isAsyncInvocation(context)) {
            try {
                return this.asyncEndpoint.invokeAsync(this.sessionId, null, context.getMethod(), context.getParameters());
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Throwable e) {
                throw new RuntimeException("Encountered an error dispatching asynchronous invocation: " + context, e);
            }
        }
        return context.proceed();
    }

    private boolean isAsyncInvocation(InvocationContext context) {
        assert (context != null) : "context must be supplied";
        Method invokedMethod = context.getMethod();
        return AsyncUtil.methodIsAsynchronous((Method)invokedMethod, (AsyncMethodsMetaData)this.asyncMethods);
    }
}

