/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.render.Renderer;
import org.apache.myfaces.shared_impl.renderkit.RendererUtils;
import org.apache.myfaces.shared_impl.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.view.facelets.PostBuildComponentTreeOnRestoreViewEvent;

@ListenersFor(value={@ListenerFor(systemEventClass=PostAddToViewEvent.class), @ListenerFor(systemEventClass=PostBuildComponentTreeOnRestoreViewEvent.class)})
public class HtmlScriptRenderer
extends Renderer
implements PartialStateHolder,
ComponentSystemEventListener {
    private static final Logger log = Logger.getLogger(HtmlScriptRenderer.class.getName());
    private boolean _initialStateMarked;

    public void processEvent(ComponentSystemEvent event) {
        UIComponent uiTarget;
        FacesContext facesContext;
        UIComponent component;
        String target;
        if (event instanceof PostAddToViewEvent && (target = (String)(component = event.getComponent()).getAttributes().get("target")) != null) {
            facesContext = FacesContext.getCurrentInstance();
            facesContext.getViewRoot().addComponentResource(facesContext, component, target);
        }
        if (event instanceof PreRenderViewEvent && (target = (String)(component = event.getComponent()).getAttributes().get("target")) != null && (uiTarget = (facesContext = FacesContext.getCurrentInstance()).getViewRoot().getFacet(target)) == null) {
            throw new FacesException("Target for component not found");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        boolean hasChildren;
        if (facesContext == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        Map componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        boolean bl = hasChildren = component.getChildCount() > 0;
        if (resourceName != null && !"".equals(resourceName)) {
            if (hasChildren) {
                log.info("Component with resourceName " + resourceName + " and child components found. Child components will be ignored.");
            }
        } else if (hasChildren) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("script", component);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            RendererUtils.renderChildren(facesContext, component);
            writer.endElement("script");
        } else if (!facesContext.getApplication().getProjectStage().equals((Object)ProjectStage.Production)) {
            facesContext.addMessage(component.getClientId(), new FacesMessage("Component with no name and no body content, so nothing rendered."));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Resource resource;
        super.encodeEnd(facesContext, component);
        Map componentAttributesMap = component.getAttributes();
        String resourceName = (String)componentAttributesMap.get("name");
        String libraryName = (String)componentAttributesMap.get("library");
        if (resourceName == null) {
            return;
        }
        if ("".equals(resourceName)) {
            return;
        }
        if (libraryName == null) {
            if (ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName);
        } else {
            if (ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
                return;
            }
            resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
        }
        if (resource == null) {
            log.warning("Resource referenced by resourceName " + resourceName + (libraryName == null ? "" : " and libraryName " + libraryName) + " not found in call to ResourceHandler.createResource." + " It will be silenty ignored.");
            return;
        }
        ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
        writer.endElement("script");
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public Object saveState(FacesContext context) {
        return null;
    }

    public void setTransient(boolean newTransientValue) {
    }
}

