/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.Iterator;
import java.util.LinkedList;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.HQDeque;
import org.hornetq.utils.HQIterator;

public class NonConcurrentHQDeque<T>
implements HQDeque<T> {
    private static final Logger log = Logger.getLogger(NonConcurrentHQDeque.class);
    private final LinkedList<T> queue = new LinkedList();

    @Override
    public synchronized void addFirst(T t) {
        this.queue.addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.queue.add(t);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public synchronized T getFirst() {
        return this.queue.getFirst();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public HQIterator<T> iterator() {
        return new Iter();
    }

    @Override
    public T removeFirst() {
        return this.queue.removeFirst();
    }

    private class Iter
    implements HQIterator<T> {
        private Iterator<T> iter;

        private Iter() {
            this.iter = NonConcurrentHQDeque.this.queue.iterator();
        }

        @Override
        public T next() {
            if (this.iter.hasNext()) {
                return this.iter.next();
            }
            return null;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

