/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.UndeclaredThrowableException;
import javax.resource.ResourceException;
import org.jboss.util.NestedThrowable;

public class JBossResourceException
extends ResourceException
implements NestedThrowable {
    private static final long serialVersionUID = 6614203184612359692L;

    public static void rethrowAsResourceException(String message, Throwable t) throws ResourceException {
        if (t instanceof ResourceException) {
            throw (ResourceException)t;
        }
        throw new JBossResourceException(message, t);
    }

    public JBossResourceException(String msg) {
        super(msg);
    }

    public JBossResourceException(String msg, String code) {
        super(msg, code);
    }

    public JBossResourceException(String msg, String code, Throwable linked) {
        super(msg, code);
        this.setLinkedException(this.process(linked));
    }

    public JBossResourceException(String msg, Throwable linked) {
        super(msg);
        this.setLinkedException(this.process(linked));
    }

    public JBossResourceException(Throwable linked) {
        this(linked.getMessage(), linked);
    }

    public Throwable getNested() {
        return this.getLinkedException();
    }

    public Throwable getCause() {
        return this.getLinkedException();
    }

    public String getMessage() {
        return NestedThrowable.Util.getMessage((String)super.getMessage(), (Throwable)this.getLinkedException());
    }

    public void printStackTrace(PrintStream stream) {
        Exception linked = this.getLinkedException();
        if (linked == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(stream);
        }
        NestedThrowable.Util.print((Throwable)linked, (PrintStream)stream);
    }

    public void printStackTrace(PrintWriter writer) {
        Exception linked = this.getLinkedException();
        if (linked == null || NestedThrowable.PARENT_TRACE_ENABLED) {
            super.printStackTrace(writer);
        }
        NestedThrowable.Util.print((Throwable)linked, (PrintWriter)writer);
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    private Exception process(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new UndeclaredThrowableException(t);
    }
}

