/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.ConnectionValidator;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.detection.AbstractDetectorMBean;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.ServerInvokerMetadata;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkRegistryFinder;
import org.jboss.remoting.network.NetworkRegistryMBean;
import org.jboss.remoting.network.NetworkRegistryWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDetector
implements AbstractDetectorMBean {
    protected static final Logger log = Logger.getLogger(AbstractDetector.class);
    private long defaultTimeDelay = 5000L;
    private long heartbeatTimeDelay = 1000L;
    protected MBeanServer mbeanserver;
    protected ObjectName objectName;
    protected ObjectName registryObjectName;
    protected NetworkRegistryMBean networkRegistry;
    private Identity myself;
    private Timer heartbeatTimer;
    private Timer failureTimer;
    private Map servers = new HashMap();
    private Element xml;
    private Set domains = new HashSet();
    private boolean acceptLocal = false;
    private Map config = new HashMap();

    public AbstractDetector() {
        this(null);
    }

    public AbstractDetector(Map config) {
        if (config != null) {
            this.config.putAll(config);
        }
    }

    @Override
    public void setHeartbeatTimeDelay(long heartbeatTimeDelay) {
        if (heartbeatTimeDelay <= 0L || heartbeatTimeDelay >= this.defaultTimeDelay) {
            throw new IllegalArgumentException("Can not set heartbeat time delay (" + heartbeatTimeDelay + ") to a negative number or " + "to a number greater than the default time delay (" + this.defaultTimeDelay + ").");
        }
        this.heartbeatTimeDelay = heartbeatTimeDelay;
    }

    @Override
    public long getHeartbeatTimeDelay() {
        return this.heartbeatTimeDelay;
    }

    @Override
    public void setDefaultTimeDelay(long defaultTimeDelay) {
        if (defaultTimeDelay < this.heartbeatTimeDelay) {
            throw new IllegalArgumentException("Can not set the default time delay (" + defaultTimeDelay + ") to be less" + " than that of the heartbeat time delay (" + this.heartbeatTimeDelay + ").");
        }
        this.defaultTimeDelay = defaultTimeDelay;
    }

    @Override
    public long getDefaultTimeDelay() {
        return this.defaultTimeDelay;
    }

    public Detection createDetection() {
        Detection detection = null;
        ServerInvoker[] invokers = InvokerRegistry.getServerInvokers();
        if (invokers == null || invokers.length <= 0) {
            return detection;
        }
        ArrayList<ServerInvokerMetadata> l = new ArrayList<ServerInvokerMetadata>(invokers.length);
        for (int c = 0; c < invokers.length; ++c) {
            if (!invokers[c].isStarted()) continue;
            ServerInvokerMetadata serverInvoker = new ServerInvokerMetadata(invokers[c].getLocator(), invokers[c].getSupportedSubsystems());
            l.add(serverInvoker);
        }
        if (l.isEmpty()) {
            return detection;
        }
        ServerInvokerMetadata[] metadata = l.toArray(new ServerInvokerMetadata[l.size()]);
        detection = new Detection(Identity.get(this.mbeanserver), metadata);
        return detection;
    }

    @Override
    public void start() throws Exception {
        this.myself = Identity.get(this.mbeanserver);
        if (this.domains.isEmpty() && this.xml == null) {
            this.domains.add(this.myself.getDomain());
        }
        this.registryObjectName = NetworkRegistryFinder.find(this.mbeanserver);
        if (this.registryObjectName == null) {
            log.warn((Object)("Detector: " + this.getClass().getName() + " could not be loaded because the NetworkRegistry is not registered"));
            log.warn((Object)"This means that only the broadcasting of detection messages will be functional and will not be able to discover other servers.");
        } else {
            NetworkRegistryMBean o = MBeanServerInvocationHandler.newProxyInstance(this.mbeanserver, this.registryObjectName, NetworkRegistryMBean.class, false);
            this.networkRegistry = new NetworkRegistryWrapper(o);
        }
        this.startPinger(this.getPingerDelay(), this.getPingerPeriod());
        this.startHeartbeat(this.getHeartbeatDelay(), this.getHeartbeatPeriod());
    }

    protected long getPingerDelay() {
        return 5000L;
    }

    protected long getPingerPeriod() {
        return 1500L;
    }

    protected void startPinger(long delay, long period) {
        this.failureTimer = new Timer(false);
        this.failureTimer.schedule((TimerTask)new FailureDetector(), delay, period);
    }

    protected void stopPinger() {
        if (this.failureTimer != null) {
            this.failureTimer.cancel();
            this.failureTimer = null;
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopPinger();
        this.stopHeartbeat();
        this.stopPinger();
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean aBoolean) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mbeanserver = mBeanServer;
        this.objectName = objectName;
        return objectName;
    }

    @Override
    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
        if (xml != null) {
            this.domains.clear();
            NodeList domainNodes = xml.getElementsByTagName("domain");
            if (domainNodes == null || domainNodes.getLength() <= 0) {
                log.debug((Object)"No domains specified.  Will accept all domains.");
            }
            int len = domainNodes.getLength();
            for (int c = 0; c < len; ++c) {
                Node node = domainNodes.item(c);
                String domain = node.getFirstChild().getNodeValue();
                this.domains.add(domain);
                log.debug((Object)("Added domain " + domain + " to detector list."));
            }
            NodeList localNode = xml.getElementsByTagName("local");
            if (localNode != null) {
                this.acceptLocal = true;
            }
        }
    }

    @Override
    public Element getConfiguration() {
        return this.xml;
    }

    protected void startHeartbeat(long delay, long period) {
        if (this.heartbeatTimer == null) {
            this.heartbeatTimer = new Timer(false);
        }
        try {
            this.heartbeatTimer.schedule((TimerTask)new Heartbeat(), delay, period);
        }
        catch (IllegalStateException e) {
            log.debug((Object)"Unable to schedule TimerTask on existing Timer", (Throwable)e);
            this.heartbeatTimer = new Timer(false);
            this.heartbeatTimer.schedule((TimerTask)new Heartbeat(), delay, period);
        }
    }

    protected void stopHeartbeat() {
        if (this.heartbeatTimer != null) {
            try {
                this.heartbeatTimer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.heartbeatTimer = null;
        }
    }

    protected long getHeartbeatDelay() {
        return 0L;
    }

    protected long getHeartbeatPeriod() {
        return this.heartbeatTimeDelay;
    }

    protected abstract void heartbeat();

    public NetworkInstance[] forceDetection() {
        this.forceHeartbeat();
        if (this.networkRegistry != null) {
            return (NetworkInstance[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return AbstractDetector.this.networkRegistry.getServers();
                }
            });
        }
        return null;
    }

    protected abstract void forceHeartbeat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detect(final Detection detection) {
        if (detection != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Detection message received.");
                log.trace((Object)("Id = " + detection.getIdentity() != null ? detection.getIdentity().getInstanceId() : "null"));
                log.trace((Object)("isRemoteDetection() = " + this.isRemoteDetection(detection)));
            }
            if (this.isRemoteDetection(detection)) {
                try {
                    boolean found = false;
                    Server server = null;
                    Map map = this.servers;
                    synchronized (map) {
                        server = (Server)this.servers.get(detection);
                        boolean bl = found = server != null;
                        if (!found) {
                            this.servers.put(detection, new Server(detection));
                        } else {
                            server.lastDetection = System.currentTimeMillis();
                        }
                    }
                    if (!found) {
                        if (this.networkRegistry != null) {
                            log.debug((Object)(this + " detected NEW server: " + detection));
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    AbstractDetector.this.networkRegistry.addServer(detection.getIdentity(), detection.getServerInvokers());
                                    return null;
                                }
                            });
                        }
                    } else if (server.changed(detection)) {
                        this.servers.put(detection, new Server(detection));
                        if (this.networkRegistry != null) {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)(this + " detected UPDATE for server: " + detection));
                            }
                            AccessController.doPrivileged(new PrivilegedAction(){

                                public Object run() {
                                    AbstractDetector.this.networkRegistry.updateServer(detection.getIdentity(), detection.getServerInvokers());
                                    return null;
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Error during detection of: " + detection));
                    log.debug((Object)("Error during detection of: " + detection), (Throwable)e);
                }
            } else if (log.isTraceEnabled()) {
                log.trace((Object)"detection from myself - ignored");
            }
        }
    }

    protected boolean isRemoteDetection(Detection detection) {
        Identity identity;
        String domain = null;
        if (detection != null && (identity = detection.getIdentity()) != null) {
            domain = identity.getDomain();
        }
        return !(domain != null && !this.domains.isEmpty() && !this.domains.contains(domain) || !this.acceptLocal && this.myself.isSameJVM(detection.getIdentity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkInvokerServer(final Detection detection, ClassLoader cl) {
        boolean ok = false;
        ServerInvokerMetadata[] invokerMetadataArray = detection.getServerInvokers();
        ArrayList<ServerInvokerMetadata> validinvokers = new ArrayList<ServerInvokerMetadata>();
        for (int c = 0; c < invokerMetadataArray.length; ++c) {
            InvokerLocator locator = null;
            try {
                ServerInvokerMetadata invokerMetadata = invokerMetadataArray[c];
                locator = invokerMetadata.getInvokerLocator();
                boolean isValid = ConnectionValidator.checkConnection(locator, this.config);
                if (!isValid) continue;
                ok = true;
                validinvokers.add(invokerMetadata);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Successful connection check for " + locator));
                continue;
            }
            catch (Throwable ig) {
                log.debug((Object)("failed calling ping on " + detection + " due to " + ig.getMessage()));
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)ig);
            }
        }
        if (!ok) {
            try {
                if (this.networkRegistry == null) return ok;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        AbstractDetector.this.networkRegistry.removeServer(detection.getIdentity());
                        return null;
                    }
                });
                log.debug((Object)("Removed detection " + detection));
                return ok;
            }
            catch (Exception ex) {
                log.debug((Object)("Error removing server for detection (" + detection + ").  Possible network registry does not exist."));
                return ok;
            }
            finally {
                this.servers.remove(detection);
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Done checking all locators for suspected dead server.  There are " + validinvokers.size() + " out of original " + invokerMetadataArray.length + " still valid."));
            }
            if (validinvokers.size() == invokerMetadataArray.length) return ok;
            ServerInvokerMetadata[] newLocators = validinvokers.toArray(new ServerInvokerMetadata[validinvokers.size()]);
            Detection newDetection = new Detection(detection.getIdentity(), newLocators);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Since at least one invoker failed while doing connection check, will be re-evaluating detection for:\n" + newDetection));
            }
            this.detect(newDetection);
        }
        return ok;
    }

    private final class Heartbeat
    extends TimerTask {
        private int threadCounter = 0;

        private Heartbeat() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("Remoting Detector - Heartbeat Thread: " + this.threadCounter++);
            AbstractDetector.this.heartbeat();
        }
    }

    private final class Server {
        Detection detection;
        private int hashCode = 0;
        long lastDetection = System.currentTimeMillis();

        Server(Detection detection) {
            this.detection = detection;
            this.rehash(detection);
        }

        private void rehash(Detection d) {
            this.hashCode = this.hash(d);
        }

        private int hash(Detection d) {
            int hc = 0;
            InvokerLocator[] locators = d.getLocators();
            if (locators != null) {
                for (int c = 0; c < locators.length; ++c) {
                    hc += locators[c].hashCode();
                }
            }
            return hc;
        }

        boolean changed(Detection detection) {
            return this.hashCode != this.hash(detection);
        }

        public boolean equals(Object obj) {
            return obj instanceof Server && this.hashCode == obj.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private final class FailureDetector
    extends TimerTask {
        private int threadCounter = 0;

        private FailureDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Remoting Detector - Failure Detector Thread: " + this.threadCounter++);
            Map map = AbstractDetector.this.servers;
            synchronized (map) {
                if (AbstractDetector.this.servers.isEmpty()) {
                    return;
                }
                ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return AbstractDetector.class.getClassLoader();
                    }
                });
                Collection serverCollection = AbstractDetector.this.servers.values();
                Server[] serverArray = serverCollection.toArray(new Server[serverCollection.size()]);
                for (int x = 0; x < serverArray.length; ++x) {
                    Server svr = serverArray[x];
                    Detection detect = svr.detection;
                    long lastDetection = svr.lastDetection;
                    long duration = System.currentTimeMillis() - lastDetection;
                    if (duration < AbstractDetector.this.defaultTimeDelay) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("detection for: " + detect + " has not been received in: " + AbstractDetector.this.defaultTimeDelay + " ms, contacting.."));
                    }
                    if (!AbstractDetector.this.checkInvokerServer(detect, cl)) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("detection for: " + detect + " recovered on ping"));
                    }
                    svr.lastDetection = System.currentTimeMillis();
                }
            }
        }
    }
}

