/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.injection.DependsFieldInjector;
import org.jboss.injection.DependsMethodInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.Injector;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class DependsHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(DependsHandler.class);

    @Override
    public void loadXml(X xml, InjectionContainer container) {
    }

    @Override
    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Depends dep = container.getAnnotation(Depends.class, method.getDeclaringClass(), method);
        if (dep != null) {
            if (!method.getName().startsWith("set")) {
                throw new RuntimeException("@EJB can only be used with a set method: " + method);
            }
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a field can only take one object name: " + method);
            }
            ObjectName on = null;
            try {
                on = new ObjectName(names[0]);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            if (injectors.get(method) == null) {
                injectors.put(method, new DependsMethodInjector(method, on));
            }
            container.getDependencyPolicy().addDependency(names[0]);
        }
    }

    @Override
    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Depends dep = container.getAnnotation(Depends.class, field.getDeclaringClass(), field);
        if (dep != null) {
            String[] names = dep.value();
            if (names.length != 1) {
                throw new RuntimeException("@Depends on a field can only take one object name: " + field);
            }
            ObjectName on = null;
            try {
                on = new ObjectName(names[0]);
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
            if (injectors.get(field) == null) {
                injectors.put(field, new DependsFieldInjector(field, on));
            }
            container.getDependencyPolicy().addDependency(names[0]);
        }
    }

    @Override
    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        Depends dep = container.getAnnotation(Depends.class, clazz);
        if (dep == null) {
            return;
        }
        for (String dependency : dep.value()) {
            container.getDependencyPolicy().addDependency(dependency);
        }
    }
}

