/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins;

import java.net.URL;
import java.util.Set;
import org.jboss.classloading.plugins.visitor.FederatedResourceVisitor;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.SecurityActions;
import org.jboss.scanning.plugins.VFSUrlScanner;
import org.jboss.scanning.plugins.helpers.DelegateResourceFilter;
import org.jboss.scanning.plugins.helpers.VoidScanningHandle;
import org.jboss.scanning.spi.ScanningHandle;
import org.jboss.scanning.spi.ScanningPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUnitScanner
extends VFSUrlScanner {
    private final DeploymentUnit unit;

    public DeploymentUnitScanner(DeploymentUnit unit, URL ... roots) {
        super(roots);
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        this.unit = unit;
    }

    public boolean doScan() {
        return true;
    }

    protected ResourceFilter wrap(String name, ResourceFilter filter) {
        ResourceFilter ext = (ResourceFilter)this.unit.getAttachment(name, ResourceFilter.class);
        if (ext != null) {
            if (filter != null) {
                return new DelegateResourceFilter(ext, filter);
            }
            return ext;
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(Set<ScanningPlugin> plugins) throws Exception {
        Module module = (Module)AttachmentLocator.searchAncestors((DeploymentUnit)this.unit, Module.class);
        if (module == null) {
            throw new IllegalArgumentException("No module found: " + this.unit);
        }
        ScanningPlugin[] array = plugins.toArray(new ScanningPlugin[plugins.size()]);
        FederatedResourceVisitor visitor = new FederatedResourceVisitor((ResourceVisitor[])array, (ResourceFilter[])array, this.getRecurseFilters(array));
        ResourceFilter filter = visitor.getFilter();
        ResourceFilter recurseFilter = visitor.getRecurseFilter();
        filter = this.wrap(ResourceFilter.class.getName() + ".resource", filter);
        recurseFilter = this.wrap(ResourceFilter.class.getName() + ".recurse", recurseFilter);
        URL[] urls = this.isToVFS() ? DeploymentUnitScanner.toVFS(this.getRoots()) : this.getRoots();
        ClassLoader tccl = SecurityActions.setContextClassLoader(this.unit.getClassLoader());
        try {
            module.visit((ResourceVisitor)visitor, filter, recurseFilter, urls);
        }
        finally {
            SecurityActions.resetContextClassLoader(tccl);
        }
    }

    protected ScanningHandle createHandle(ScanningPlugin plugin) {
        ScanningHandle handle = plugin.createHandle();
        if (handle != VoidScanningHandle.INSTANCE) {
            this.unit.addAttachment(plugin.getAttachmentKey(), (Object)handle, plugin.getHandleInterface());
        }
        return handle;
    }
}

