/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.multiplex;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jboss.remoting.transport.multiplex.VirtualServerSocket;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class PrimeScenarioExampleClient {
    public void runPrimeScenario() {
        try {
            VirtualSocket v1 = new VirtualSocket("localhost", 5555);
            new AsynchronousThread(v1).start();
            ObjectOutputStream oos = new ObjectOutputStream(((Socket)v1).getOutputStream());
            ObjectInputStream ois = new ObjectInputStream(((Socket)v1).getInputStream());
            oos.writeObject(new Integer(3));
            Integer i1 = (Integer)ois.readObject();
            System.out.println("synch: " + i1);
            ((Socket)v1).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new PrimeScenarioExampleClient().runPrimeScenario();
    }

    class AsynchronousThread
    extends Thread {
        private Socket virtualSocket;

        AsynchronousThread(Socket virtualSocket) {
            this.virtualSocket = virtualSocket;
        }

        @Override
        public void run() {
            try {
                VirtualServerSocket serverSocket = new VirtualServerSocket(this.virtualSocket.getLocalPort());
                ((ServerSocket)serverSocket).setSoTimeout(10000);
                Socket v4 = ((ServerSocket)serverSocket).accept();
                ObjectInputStream ois = new ObjectInputStream(v4.getInputStream());
                v4.setSoTimeout(10000);
                Object o = ois.readObject();
                System.out.println("asynch: " + (Integer)o);
                ((ServerSocket)serverSocket).close();
                v4.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

