/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.uuidgen;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.juddi.util.Config;
import org.apache.juddi.uuidgen.UUIDGen;

public final class NativeUUIDGen
implements UUIDGen {
    private static final String COMMAND_KEY = "juddi.uuidgenCommand";
    private static final String DEFAULT_COMMAND = "uuidgen";
    private String command = Config.getStringProperty("juddi.uuidgenCommand", "uuidgen");

    public String uuidgen() {
        try {
            Runtime r = Runtime.getRuntime();
            Process p = r.exec(this.command);
            BufferedReader x = new BufferedReader(new InputStreamReader(p.getInputStream()));
            return x.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] uuidgen(int nmbr) {
        String[] uuids = new String[nmbr];
        for (int i = 0; i < uuids.length; ++i) {
            uuids[i] = this.uuidgen();
        }
        return uuids;
    }

    public static void main(String[] args) {
        NativeUUIDGen generator = new NativeUUIDGen();
        long start = System.currentTimeMillis();
        for (int i = 1; i <= 100; ++i) {
            generator.uuidgen();
        }
        long end = System.currentTimeMillis();
        System.out.println("\nNativeUUIDGen: Generation of 100 UUID's took " + (end - start) + " milliseconds.");
    }
}

