/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class FindQualifiersHandler
extends AbstractHandler {
    public static final String TAG_NAME = "findQualifiers";
    private HandlerMaker maker = null;

    protected FindQualifiersHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        FindQualifiers obj = new FindQualifiers();
        Vector nodeList = null;
        AbstractHandler handler = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "findQualifier");
        for (int i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("findQualifier");
            obj.addFindQualifier((FindQualifier)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        FindQualifiers qualifiers = (FindQualifiers)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        Vector qVector = qualifiers.getFindQualifierVector();
        if (qVector != null && qVector.size() > 0) {
            handler = this.maker.lookup("findQualifier");
            for (int i = 0; i < qVector.size(); ++i) {
                handler.marshal((FindQualifier)qVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        FindQualifiers qualifiers = new FindQualifiers();
        qualifiers.addFindQualifier(new FindQualifier("sortByDateAsc"));
        qualifiers.addFindQualifier(new FindQualifier("andAllKeys"));
        System.out.println();
        RegistryObject regObject = qualifiers;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
    }
}

