/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.hibernate;

import java.net.URL;
import org.jboss.classloading.spi.visitor.ResourceContext;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.scanning.hibernate.PatternFilter;
import org.jboss.scanning.hibernate.ResourceNamedInputStream;
import org.jboss.scanning.hibernate.ScannerImpl;

public class PatternVisitor
implements ResourceVisitor {
    private final String pattern;
    private final PatternFilter filter;
    private final ScannerImpl scanner;

    public PatternVisitor(String pattern, ScannerImpl scanner) {
        if (pattern == null) {
            throw new IllegalArgumentException("Null pattern");
        }
        if (scanner == null) {
            throw new IllegalArgumentException("Null scanner");
        }
        this.pattern = pattern;
        this.filter = new PatternFilter(pattern);
        this.scanner = scanner;
    }

    public ResourceFilter getFilter() {
        return this.filter;
    }

    public void visit(ResourceContext resource) {
        URL ownerURL = this.scanner.getOwnerURL(resource);
        this.scanner.addFile(ownerURL, this.pattern, new ResourceNamedInputStream(resource));
    }
}

