/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.spi.FileSystem;
import org.jboss.vfs.spi.MountHandle;

class BasicMountHandle
implements MountHandle {
    private final FileSystem fileSystem;
    private final Closeable mountHandle;
    private final Closeable[] closeables;

    public BasicMountHandle(FileSystem fileSystem, Closeable mountHandle, Closeable ... additionalCloseables) {
        this.fileSystem = fileSystem;
        this.mountHandle = mountHandle;
        this.closeables = additionalCloseables;
    }

    @Override
    public File getMountSource() {
        return this.fileSystem.getMountSource();
    }

    @Override
    public void close() throws IOException {
        VFSUtils.safeClose((Closeable)this.fileSystem);
        VFSUtils.safeClose(this.mountHandle);
        for (Closeable closeable : this.closeables) {
            VFSUtils.safeClose(closeable);
        }
    }
}

