/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.async.spi;

import org.jboss.ejb3.async.spi.AsyncInvocationId;
import org.jboss.ejb3.async.spi.lang.ThreadLocalStack;
import org.jboss.logging.Logger;

public class CurrentAsyncInvocation {
    private static final Logger log = Logger.getLogger(CurrentAsyncInvocation.class);
    private static final ThreadLocalStack<AsyncInvocationId> CURRENT_EXECUTING_INVOCATIONS = new ThreadLocalStack();

    private CurrentAsyncInvocation() {
        throw new UnsupportedOperationException("No instances");
    }

    public static AsyncInvocationId getCurrentAsyncInvocationId() {
        return CURRENT_EXECUTING_INVOCATIONS.get();
    }

    public static void markCurrentInvocationOnThread(AsyncInvocationId uuid) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Putting current invocation on Thread " + Thread.currentThread() + ":  " + uuid));
        }
        CURRENT_EXECUTING_INVOCATIONS.push(uuid);
    }

    public static AsyncInvocationId unmarkCurrentInvocationFromThread() {
        AsyncInvocationId id = CURRENT_EXECUTING_INVOCATIONS.pop();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing current invocation from Thread " + Thread.currentThread() + ":  " + id));
        }
        return id;
    }
}

