/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jetbrains.annotations.Nullable;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DebugUtils {
    public static String convertPropertiesToString(ManagedComponent managedComponent) {
        StringBuilder buf = new StringBuilder();
        String componentTypeName = managedComponent.getType().getSubtype() + " " + managedComponent.getType().getType();
        buf.append("Properties for [").append(componentTypeName).append("] ManagedComponent [");
        buf.append(managedComponent.getName()).append("]:\n");
        buf.append(DebugUtils.convertPropertiesToString(managedComponent.getProperties()));
        return buf.toString();
    }

    public static String convertPropertiesToString(DeploymentTemplateInfo template) {
        StringBuilder buf = new StringBuilder();
        buf.append("Properties for DeploymentTemplateInfo [").append(template.getName()).append("]:\n");
        buf.append(DebugUtils.convertPropertiesToString(template.getProperties()));
        return buf.toString();
    }

    public static String convertMetaValueToString(MetaValue metaValue) {
        StringBuilder buffer = new StringBuilder();
        DebugUtils.convertMetaValueToString(metaValue, buffer, true, 1);
        return buffer.toString();
    }

    public static String convertPropertiesToString(Map<String, ManagedProperty> managedProps) {
        StringBuilder buf = new StringBuilder();
        ArrayList<ManagedProperty> props = new ArrayList<ManagedProperty>(managedProps.values());
        Collections.sort(props, new ManagedPropertyComparator());
        try {
            for (ManagedProperty managedProperty : props) {
                if (managedProperty.isMandatory()) {
                    buf.append("* ");
                } else {
                    buf.append("  ");
                }
                buf.append("name=").append(managedProperty.getName());
                if (!managedProperty.getName().equals(managedProperty.getMappedName())) {
                    buf.append(", mappedName=").append(managedProperty.getMappedName());
                }
                EnumSet<ViewUse> viewUses = ManagedComponentUtils.getViewUses(managedProperty);
                buf.append(", viewUses=").append(viewUses);
                buf.append(", readOnly=").append(managedProperty.isReadOnly());
                buf.append(", mandatory=").append(managedProperty.isMandatory());
                buf.append(", removed=").append(managedProperty.isRemoved());
                MetaValue value = managedProperty.getValue();
                if (value == null) {
                    buf.append(", type=").append(managedProperty.getMetaType());
                }
                buf.append(", value=").append(DebugUtils.convertMetaValueToString(value));
            }
        }
        catch (Exception e) {
            buf.append(" ... Failed to convert properties to string: " + e.getMessage());
        }
        return buf.toString();
    }

    private static void convertMetaValueToString(MetaValue metaValue, StringBuilder buffer, boolean indentFirstLine, int indentLevel) {
        if (indentFirstLine) {
            for (int i = 0; i < indentLevel; ++i) {
                buffer.append("  ");
            }
        }
        if (metaValue == null) {
            buffer.append("<<<null>>>\n");
        } else if (metaValue.getMetaType().isCollection()) {
            CollectionValue collectionValue = (CollectionValue)metaValue;
            buffer.append(collectionValue).append("\n");
        } else if (metaValue.getMetaType().isComposite()) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            buffer.append(compositeValue).append("\n");
        } else {
            buffer.append(metaValue).append("\n");
        }
    }

    private DebugUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedPropertyComparator
    implements Comparator<ManagedProperty> {
        private ManagedPropertyComparator() {
        }

        @Override
        public int compare(ManagedProperty prop1, ManagedProperty prop2) {
            ViewUse prop1ViewUse = ManagedPropertyComparator.getPrimaryViewUse(prop1);
            ViewUse prop2ViewUse = ManagedPropertyComparator.getPrimaryViewUse(prop2);
            if (prop1ViewUse == null) {
                return prop2ViewUse == null ? 0 : -1;
            }
            if (prop2ViewUse == null) {
                return 1;
            }
            int result = prop1ViewUse.name().compareTo(prop2ViewUse.name());
            if (result == 0) {
                result = prop1.getName().compareTo(prop2.getName());
            }
            return result;
        }

        @Nullable
        private static ViewUse getPrimaryViewUse(ManagedProperty managedProperty) {
            Object viewUse = managedProperty.hasViewUse(ViewUse.CONFIGURATION) ? ViewUse.CONFIGURATION : (managedProperty.hasViewUse(ViewUse.RUNTIME) ? ViewUse.RUNTIME : (managedProperty.hasViewUse(ViewUse.STATISTIC) ? ViewUse.STATISTIC : null));
            return viewUse;
        }
    }
}

