/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.helper;

import com.jboss.jbossnetwork.product.jbpm.handlers.ControlActionFacade;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.operation.OperationServicesResult;
import org.rhq.core.pluginapi.operation.OperationServicesResultCode;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.ApplicationServerSupportedOperations;

public class InPluginControlActionFacade
implements ControlActionFacade {
    private ApplicationServerComponent serverComponent;
    private final Log log = LogFactory.getLog(this.getClass());

    public InPluginControlActionFacade(ApplicationServerComponent serverComponent) {
        this.serverComponent = serverComponent;
    }

    public OperationServicesResult start() {
        String operationName = ApplicationServerSupportedOperations.START.name().toLowerCase();
        try {
            this.serverComponent.invokeOperation(operationName, null);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Start interrupted.", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OperationServicesResultCode code = this.serverComponent.getAvailability() == AvailabilityType.UP ? OperationServicesResultCode.SUCCESS : OperationServicesResultCode.FAILURE;
        OperationServicesResult result = new OperationServicesResult(code);
        return result;
    }

    public OperationServicesResult stop() {
        String operationName = ApplicationServerSupportedOperations.SHUTDOWN.name().toLowerCase();
        try {
            this.serverComponent.invokeOperation(operationName, null);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"Shutdown interrupted.", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        OperationServicesResultCode code = this.serverComponent.getAvailability() == AvailabilityType.DOWN ? OperationServicesResultCode.SUCCESS : OperationServicesResultCode.FAILURE;
        OperationServicesResult result = new OperationServicesResult(code);
        return result;
    }

    public boolean isRunning() {
        return this.serverComponent.getAvailability() == AvailabilityType.UP;
    }
}

