/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.AbstractManagedDeploymentComponent;
import org.rhq.plugins.jbossas5.ManagedComponentDiscoveryComponent;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3BeanDiscoveryComponent
extends ManagedComponentDiscoveryComponent<AbstractManagedDeploymentComponent> {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<AbstractManagedDeploymentComponent> discoveryContext) throws Exception {
        ResourceType resourceType = discoveryContext.getResourceType();
        this.log.trace((Object)("Discovering " + resourceType.getName() + " Resources..."));
        ManagementView managementView = ((AbstractManagedDeploymentComponent)discoveryContext.getParentResourceComponent()).getConnection().getManagementView();
        managementView.load();
        AbstractManagedDeploymentComponent parentResourceComponent = (AbstractManagedDeploymentComponent)discoveryContext.getParentResourceComponent();
        ManagedDeployment parentDeployment = parentResourceComponent.getManagedDeployment();
        Collection components = parentDeployment.getComponents().values();
        ComponentType componentType = this.getComponentType(discoveryContext);
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        for (ManagedComponent component : components) {
            String ejbName;
            if (!component.getType().equals((Object)componentType)) continue;
            String resourceKey = ejbName = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(component, "name"));
            String resourceName = ejbName;
            String version = null;
            Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
            pluginConfig.put((Property)new PropertySimple("componentName", (Object)component.getName()));
            DiscoveredResourceDetails resource = new DiscoveredResourceDetails(resourceType, resourceKey, resourceName, version, resourceType.getDescription(), pluginConfig, null);
            discoveredResources.add(resource);
        }
        this.log.trace((Object)("Discovered " + discoveredResources.size() + " " + resourceType.getName() + " Resources."));
        return discoveredResources;
    }
}

