/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts.utils;

import com.arjuna.ArjunaOTS.UidCoordinator;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jts.utils.Helper;
import java.io.PrintWriter;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Vote;
import org.omg.CosTransactions.otid_t;

public class Utility {
    public static String getHierarchy(PropagationContext ctx) {
        int depth = ctx.parents != null ? ctx.parents.length : 0;
        String hier = "PropagationContext:";
        for (int i = depth - 1; i >= 0; --i) {
            if (ctx.parents[i] == null) continue;
            hier = hier + "\n" + Utility.otidToUid(ctx.parents[i].otid);
        }
        hier = hier + "\n" + Utility.otidToUid(ctx.current.otid);
        return hier;
    }

    public static String stringVote(Vote v) {
        switch (v.value()) {
            case 0: {
                return "CosTransactions::VoteCommit";
            }
            case 1: {
                return "CosTransactions::VoteRollback";
            }
            case 2: {
                return "CosTransactions::VoteReadOnly";
            }
        }
        return "Unknown";
    }

    public static PrintWriter printStatus(PrintWriter strm, Status res) {
        strm.print(Utility.stringStatus(res));
        return strm;
    }

    public static String stringStatus(Status res) {
        switch (res.value()) {
            case 0: {
                return "CosTransactions::StatusActive";
            }
            case 1: {
                return "CosTransactions::StatusMarkedRollback";
            }
            case 2: {
                return "CosTransactions::StatusPrepared";
            }
            case 3: {
                return "CosTransactions::StatusCommitted";
            }
            case 4: {
                return "CosTransactions::StatusRolledBack";
            }
            case 5: {
                return "CosTransactions::StatusUnknown";
            }
            case 6: {
                return "CosTransactions::StatusPreparing";
            }
            case 7: {
                return "CosTransactions::StatusCommitting";
            }
            case 8: {
                return "CosTransactions::StatusRollingBack";
            }
            case 9: {
                return "CosTransactions::StatusNoTransaction";
            }
        }
        return "Unknown";
    }

    public static final Uid getUid(Control cont) {
        try {
            UidCoordinator coord = Helper.getUidCoordinator(cont);
            if (coord == null) {
                throw new BAD_PARAM();
            }
            return Helper.getUid(coord);
        }
        catch (BAD_PARAM ex) {
            return Uid.nullUid();
        }
    }

    public static final otid_t uidToOtid(Uid theUid) {
        return theUid != null ? Utility.uidToOtid(theUid.stringForm()) : null;
    }

    public static final otid_t uidToOtid(String theUid) {
        if (theUid == null) {
            return null;
        }
        otid_t otid = new otid_t();
        byte[] b = theUid.getBytes();
        byte[] nodeName = TxControl.getXANodeName();
        otid.formatID = 0;
        otid.tid = new byte[b.length + nodeName.length];
        otid.bqual_length = nodeName.length;
        System.arraycopy(b, 0, otid.tid, 0, b.length);
        System.arraycopy(nodeName, 0, otid.tid, b.length, nodeName.length);
        b = null;
        return otid;
    }

    public static final Uid otidToUid(otid_t otid) {
        if (otid.bqual_length > 0) {
            int uidLength = otid.tid.length - otid.bqual_length;
            byte[] theUid = new byte[uidLength];
            System.arraycopy(otid.tid, 0, theUid, 0, uidLength);
            Uid u = new Uid(new String(theUid), true);
            theUid = null;
            return u;
        }
        return Uid.nullUid();
    }
}

