/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.RegistryObject;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.RegistryObjectImpl;

public class AssociationImpl
extends RegistryObjectImpl
implements Association {
    private Concept type = null;
    private RegistryObject source = null;
    private RegistryObject target = null;
    private boolean isConfirmed = true;
    private boolean isConfirmedBySourceOwner = true;
    private boolean isConfirmedByTargetOwner = true;
    private boolean isExtramural = true;

    public AssociationImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public AssociationImpl(LifeCycleManager lifeCycleManager, InternationalString n) {
        super(lifeCycleManager, n);
    }

    public Concept getAssociationType() throws JAXRException {
        return this.type;
    }

    public RegistryObject getSourceObject() throws JAXRException {
        return this.source;
    }

    public RegistryObject getTargetObject() throws JAXRException {
        return this.target;
    }

    public boolean isConfirmed() throws JAXRException {
        return this.isConfirmed;
    }

    public boolean isConfirmedBySourceOwner() throws JAXRException {
        return this.isConfirmedBySourceOwner;
    }

    public boolean isConfirmedByTargetOwner() throws JAXRException {
        return this.isConfirmedByTargetOwner;
    }

    public boolean isExtramural() throws JAXRException {
        return this.isExtramural;
    }

    public void setAssociationType(Concept concept) throws JAXRException {
        this.type = concept;
    }

    public void setSourceObject(RegistryObject ro) throws JAXRException {
        this.source = ro;
    }

    public void setTargetObject(RegistryObject ro) throws JAXRException {
        this.target = ro;
    }

    public Key getKey() {
        String id = null;
        KeyImpl key = null;
        try {
            id = this.source.getKey().getId();
            id = id + ":" + this.target.getKey().getId();
            Key k = null;
            if (this.type != null) {
                k = this.type.getKey();
            }
            id = k == null || k.getId() == "" ? id + ":NULL" : id + ":" + k.getId();
            id = id + ":Concept";
            id = this.type != null ? id + ":" + this.type.getValue() : id + ":NULL";
        }
        catch (JAXRException e) {
            throw new RuntimeException(e);
        }
        if (id != null) {
            key = new KeyImpl(id);
        }
        return key;
    }

    public void setConfirmed(boolean b) {
        this.isConfirmed = b;
    }

    public void setConfirmedBySourceOwner(boolean b) {
        this.isConfirmedBySourceOwner = b;
    }

    public void setConfirmedByTargetOwner(boolean b) {
        this.isConfirmedByTargetOwner = b;
    }

    public void setExtramural(boolean b) {
        this.isExtramural = b;
    }
}

