/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.wsf.common.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class RMSerializationHelper {
    private RMSerializationHelper() {
    }

    public static String getRequiredTextContent(SOAPElement element, QName elementQName) {
        if (!DOMUtils.hasTextChildNodesOnly((Node)element)) {
            throw new RMException("Only text content is allowed for element " + elementQName);
        }
        return DOMUtils.getTextContent((Node)element).trim();
    }

    public static SOAPElement getRequiredElement(SOAPElement element, QName requiredQName, QName contextQName) {
        return RMSerializationHelper.getRequiredElement(element, requiredQName, contextQName.toString());
    }

    public static SOAPElement getRequiredElement(SOAPElement element, QName requiredQName, String context) {
        List childElements = DOMUtils.getChildElementsAsList((Node)element, (QName)requiredQName);
        if (childElements.size() < 1) {
            throw new RMException("Required " + requiredQName + " element not found in " + context + " element");
        }
        if (childElements.size() > 1) {
            throw new RMException("Only one " + requiredQName + " element can be present in " + context + " element");
        }
        return (SOAPElement)childElements.get(0);
    }

    public static String getRequiredTextContent(SOAPElement element, QName attributeQName, QName elementQName) {
        String attributeValue = element.getAttributeValue(attributeQName);
        if (attributeValue == null) {
            throw new RMException("Required attribute " + attributeQName + " is missing in element " + elementQName);
        }
        return attributeValue;
    }

    public static SOAPElement getOptionalElement(SOAPElement contextElement, QName optionalQName, QName contextQName) {
        List list = DOMUtils.getChildElementsAsList((Node)contextElement, (QName)optionalQName);
        if (list.size() > 1) {
            throw new RMException("At most one " + optionalQName + " element can be present in " + contextQName + " element");
        }
        return (SOAPElement)(list.size() == 1 ? (Element)list.get(0) : null);
    }

    public static List<SOAPElement> getOptionalElements(SOAPElement contextElement, QName optionalQName, QName contextQName) {
        List temp = DOMUtils.getChildElementsAsList((Node)contextElement, (QName)optionalQName);
        if (temp.size() == 0) {
            return Collections.emptyList();
        }
        LinkedList<SOAPElement> retVal = new LinkedList<SOAPElement>();
        for (Element e : temp) {
            retVal.add((SOAPElement)e);
        }
        return retVal;
    }

    public static long stringToLong(String toEvaluate, String errorMessage) {
        try {
            return Long.valueOf(toEvaluate);
        }
        catch (NumberFormatException nfe) {
            throw new RMException(errorMessage, nfe);
        }
    }
}

