/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class SARArchiveFilter
implements VirtualFileFilter {
    private static final String REGEXP = "regexp=";
    private Pattern regexp;
    private Set<String> patterns;
    private boolean allowAll = false;

    public SARArchiveFilter(String patternsString) {
        if (patternsString == null) {
            throw new IllegalArgumentException("Null patternsString");
        }
        if (patternsString.startsWith(REGEXP)) {
            this.regexp = Pattern.compile(patternsString.substring(REGEXP.length()));
        } else {
            StringTokenizer tokens = new StringTokenizer(patternsString, ",");
            this.patterns = new HashSet<String>(tokens.countTokens());
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                this.patterns.add(token.trim());
            }
            this.allowAll = this.patterns.contains("*");
        }
    }

    public boolean accepts(VirtualFile file) {
        if (this.allowAll) {
            return true;
        }
        String fileName = file.getName();
        if (this.regexp != null) {
            return this.regexp.matcher(fileName).matches();
        }
        return this.patterns.contains(fileName);
    }
}

