/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui.content;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.on.embedded.ui.content.AbstractFileUploadAction;
import org.jboss.on.embedded.ui.nav.JONTreeNode;
import org.jboss.on.embedded.ui.nav.ResourceTreeNode;
import org.jboss.on.embedded.util.ContentUtility;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.server.content.ContentDiscoveryReport;
import org.rhq.core.clientapi.server.content.DeployPackagesRequest;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.content.ContentManager;

@Name(value="updateBackingContentAction")
@Scope(value=ScopeType.CONVERSATION)
public class UpdateBackingContentAction
extends AbstractFileUploadAction
implements Serializable {
    private final Log log = LogFactory.getLog(this.getClass());
    @Out
    private ResourceType resourceType;
    @Out
    private Resource resource;
    @Out
    private PackageType packageType;
    @Out
    private ResourcePackageDetails packageDetails;

    @Begin(join=true)
    public String init() {
        this.log.debug((Object)"Initializing updateBackingContentAction Seam component...");
        JONTreeNode selectedNode = this.navigationAction.getSelectedNode();
        ResourceTreeNode resourceTreeNode = (ResourceTreeNode)selectedNode;
        this.resource = resourceTreeNode.getResource();
        this.log.debug((Object)("Current Resource is " + this.resource));
        this.resourceType = this.resource.getResourceType();
        this.packageType = ContentUtility.getCreationPackageType(this.resourceType);
        if (this.packageType == null) {
            this.log.error((Object)(this.resourceType + " has no associated creation package type."));
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.create.resourceTypeHasNoCreationPackageType", new Object[0]);
            return "failure";
        }
        try {
            this.packageDetails = this.getBackingPackage();
        }
        catch (Exception e) {
            this.facesMessages.add(FacesMessage.SEVERITY_ERROR, e.getLocalizedMessage(), new Object[0]);
            return "failure";
        }
        return "success";
    }

    @End(ifOutcome={"success"})
    public String updateBackingContent() {
        DeployIndividualPackageResponse deployPackageResponse;
        File tempFile;
        if (this.getFileName() == null) {
            this.log.error((Object)("No file was specified in request to update backing file for " + this.resource + "."));
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.update.noFileSelected", new Object[0]);
            return "failure";
        }
        if (!this.getFileName().equals(this.packageDetails.getFileName())) {
            this.log.error((Object)("Specified file '" + this.getFileName() + "' does not have same filename as existing file '" + this.packageDetails.getFileName() + "' for " + this.resource + "."));
            this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_WARN, "content.resourceInstance.update.wrongFileName", new Object[]{this.packageType.getDisplayName(), this.packageDetails.getFileName()});
            return "failure";
        }
        this.log.debug((Object)("Updating content-backed " + this.resourceType + " Resource " + this.getFileName() + "..."));
        try {
            tempFile = this.writeTempFile();
        }
        catch (IOException e) {
            return "failure";
        }
        String version = String.valueOf(System.currentTimeMillis());
        PackageDetailsKey key = new PackageDetailsKey(tempFile.getPath(), version, this.packageType.getName(), "no-arch");
        ResourcePackageDetails detail = new ResourcePackageDetails(key);
        HashSet<ResourcePackageDetails> packageDetails = new HashSet<ResourcePackageDetails>();
        packageDetails.add(detail);
        DeployPackagesRequest deployPackagesRequest = new DeployPackagesRequest(1, this.resource.getId(), packageDetails);
        ContentManager contentManager = PluginContainer.getInstance().getContentManager();
        try {
            DeployPackagesResponse deployPackagesResponse = contentManager.deployPackagesImmediately(deployPackagesRequest);
            deployPackageResponse = (DeployIndividualPackageResponse)deployPackagesResponse.getPackageResponses().iterator().next();
        }
        catch (Exception e) {
            this.facesMessages.add(FacesMessage.SEVERITY_FATAL, e.getLocalizedMessage(), new Object[0]);
            return "failure";
        }
        switch (deployPackageResponse.getResult()) {
            case SUCCESS: {
                this.facesMessages.add(FacesMessage.SEVERITY_INFO, "{0} {1} updated.", new Object[]{this.packageType.getDisplayName(), this.packageDetails.getFileName()});
                return "success";
            }
        }
        String cause = deployPackageResponse.getErrorMessage() != null ? deployPackageResponse.getErrorMessage() : "unknown";
        this.facesMessages.addFromResourceBundle(FacesMessage.SEVERITY_ERROR, "content.resourceInstance.update.failure", new Object[]{this.getFileName(), cause});
        return "failure";
    }

    private ResourcePackageDetails getBackingPackage() throws Exception {
        ContentDiscoveryReport report;
        try {
            report = PluginContainer.getInstance().getContentManager().executeResourcePackageDiscoveryImmediately(this.resource.getId(), this.packageType.getName());
            if (report.getDeployedPackages().isEmpty()) {
                throw new IllegalStateException("Backing " + this.packageType.getName() + " package not found for " + this.resource + ".");
            }
            if (report.getDeployedPackages().size() > 1) {
                throw new IllegalStateException("More than one " + this.packageType.getName() + " package found for " + this.resource + ".");
            }
        }
        catch (PluginContainerException e) {
            throw new Exception("Failed to discover underlying " + this.packageType.getName() + " package for " + this.resourceType.getName() + " Resource.", e);
        }
        ResourcePackageDetails packageDetails = (ResourcePackageDetails)report.getDeployedPackages().iterator().next();
        this.log.debug((Object)("Backing package for " + this.resource + " is " + packageDetails + "."));
        return packageDetails;
    }
}

