/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.on.embedded.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.on.embedded.bean.MeasurementDisplay;
import org.jboss.on.embedded.bean.MeasurementUtils;
import org.jboss.on.embedded.bean.ResourceListItem;
import org.jboss.on.embedded.ui.CommonActionUtil;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.faces.FacesMessages;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;

@Name(value="metricAction")
public class MetricAction {
    @In
    private transient FacesMessages facesMessages;
    @Out(required=false)
    private ResourceListItem currentResource;
    @Out(required=false)
    private ResourceType resourceType;
    @Out(required=false)
    private Map<String, MeasurementDefinition> measurementDefinitionMap;
    @Out(required=false)
    private List<String> measurementCategoryList;
    @Out(required=false)
    private Map<String, List<MeasurementDisplay>> measurementDisplayMap;
    @Out(required=false)
    private List<Map<String, MeasurementDisplay>> traitDisplayList;
    @In(create=true)
    private CommonActionUtil commonActionUtil;
    @Out(required=false)
    private List<String> disabledTabs;

    public String view() {
        this.currentResource = this.commonActionUtil.getCurrentResourceListItem();
        this.resourceType = this.currentResource.getResource().getResourceType();
        this.measurementDisplayMap = new HashMap<String, List<MeasurementDisplay>>();
        MeasurementUtils measurementUtils = new MeasurementUtils(this.currentResource);
        this.measurementDefinitionMap = measurementUtils.getMeasurementDefinitionMap();
        List<MeasurementData> measurementDataList = measurementUtils.loadMeasurementData(null, DataType.MEASUREMENT);
        this.measurementCategoryList = measurementUtils.loadCategoryList(this.measurementDefinitionMap, measurementDataList, this.measurementDisplayMap);
        List<MeasurementData> traitDataList = measurementUtils.loadMeasurementData(null, DataType.TRAIT);
        if (traitDataList != null) {
            this.traitDisplayList = new ArrayList<Map<String, MeasurementDisplay>>();
            String[] columnNames = new String[]{"a", "b"};
            int columnCount = 0;
            HashMap<String, MeasurementDisplay> currentMap = new HashMap<String, MeasurementDisplay>();
            for (MeasurementData traitData : traitDataList) {
                if (columnCount % columnNames.length == 0) {
                    currentMap = new HashMap();
                    this.traitDisplayList.add(currentMap);
                }
                currentMap.put(columnNames[columnCount % columnNames.length], measurementUtils.createMeasurementDisplay(traitData, this.measurementDefinitionMap.get(traitData.getName())));
                ++columnCount;
            }
        }
        return "success";
    }
}

