/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagementSupport;
import org.rhq.core.pc.configuration.ConfigurationUpdateException;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredAndRawConfigManagement
extends ConfigManagementSupport {
    private final Log log = LogFactory.getLog(StructuredAndRawConfigManagement.class);

    @Override
    public Configuration executeLoad(int resourceId) throws PluginContainerException {
        ResourceConfigurationFacet facet = this.loadResouceConfiguratonFacet(resourceId);
        Configuration configuration = facet.loadStructuredConfiguration();
        Set rawConfigs = facet.loadRawConfigurations();
        if (configuration == null && rawConfigs == null) {
            return null;
        }
        if (configuration == null) {
            configuration = new Configuration();
        }
        if (rawConfigs == null) {
            rawConfigs = Collections.EMPTY_SET;
        }
        for (RawConfiguration rawConfig : rawConfigs) {
            configuration.addRawConfiguration(rawConfig);
        }
        ResourceType resourceType = this.componentService.getResourceType(resourceId);
        if (configuration.getNotes() == null) {
            configuration.setNotes("Resource config for " + resourceType.getName() + " Resource w/ id " + resourceId);
        }
        this.configUtilityService.normalizeConfiguration(configuration, resourceType.getResourceConfigurationDefinition());
        List<String> errorMsgs = this.configUtilityService.validateConfiguration(configuration, resourceType.getResourceConfigurationDefinition());
        this.logErrorMsgs(errorMsgs, resourceType);
        return configuration;
    }

    private void logErrorMsgs(List<String> errorMsgs, ResourceType resourceType) {
        for (String errorMessage : errorMsgs) {
            this.log.warn((Object)("Plugin Error: Invalid " + resourceType.getName() + " Resource configuration returned by " + resourceType.getPlugin() + " plugin - " + errorMessage));
        }
    }

    @Override
    public void executeUpdate(int resourceId, Configuration configuration) throws PluginContainerException {
        ResourceConfigurationFacet facet = this.loadResourceConfigFacetWithWriteLock(resourceId);
        StringBuilder errors = new StringBuilder();
        try {
            facet.validateStructuredConfiguration(configuration);
            facet.persistStructuredConfiguration(configuration);
        }
        catch (Throwable t) {
            errors.append(t.getMessage());
        }
        for (RawConfiguration rawConfig : configuration.getRawConfigurations()) {
            try {
                facet.validateRawConfiguration(rawConfig);
                facet.persistRawConfiguration(rawConfig);
            }
            catch (Throwable t) {
                errors.append(t.getMessage()).append("\n\n");
            }
        }
        if (errors.length() > 0) {
            throw new ConfigurationUpdateException(errors.toString());
        }
    }
}

