/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.configuration.ConfigurationAgentService;
import org.rhq.core.clientapi.agent.configuration.ConfigurationUpdateRequest;
import org.rhq.core.clientapi.server.configuration.ConfigurationServerService;
import org.rhq.core.clientapi.server.configuration.ConfigurationUpdateResponse;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.RawConfiguration;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.agent.AgentService;
import org.rhq.core.pc.configuration.ConfigManagement;
import org.rhq.core.pc.configuration.ConfigManagementFactory;
import org.rhq.core.pc.configuration.ConfigurationCheckExecutor;
import org.rhq.core.pc.configuration.LegacyConfigManagement;
import org.rhq.core.pc.configuration.UpdateResourceConfigurationRunner;
import org.rhq.core.pc.util.ComponentService;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pc.util.LoggingThreadFactory;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;
import org.rhq.core.util.MessageDigestGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager
extends AgentService
implements ContainerService,
ConfigurationAgentService {
    private final Log log = LogFactory.getLog(ConfigurationManager.class);
    private static final String SENDER_THREAD_POOL_NAME = "ConfigurationManager.threadpool";
    private static final int FACET_METHOD_TIMEOUT = 60000;
    private PluginContainerConfiguration pluginContainerConfiguration;
    private ScheduledExecutorService threadPool;
    private ComponentService componentService;
    private ConfigManagementFactory configMgmtFactory;

    public ConfigurationManager() {
        super(ConfigurationAgentService.class);
    }

    @Override
    public void initialize() {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(SENDER_THREAD_POOL_NAME, true);
        this.threadPool = new ScheduledThreadPoolExecutor(1, threadFactory);
        ConfigurationCheckExecutor configurationChecker = new ConfigurationCheckExecutor(this, this.getConfigurationServerService(), PluginContainer.getInstance().getInventoryManager());
        if (this.pluginContainerConfiguration.getConfigurationDiscoveryPeriod() > 0L && this.pluginContainerConfiguration.isInsideAgent()) {
            this.threadPool.scheduleAtFixedRate(configurationChecker, this.pluginContainerConfiguration.getConfigurationDiscoveryInitialDelay(), this.pluginContainerConfiguration.getConfigurationDiscoveryPeriod(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void shutdown() {
        this.threadPool.shutdown();
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.pluginContainerConfiguration = configuration;
    }

    public void setComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    public void setConfigManagementFactory(ConfigManagementFactory factory) {
        this.configMgmtFactory = factory;
    }

    public void updateResourceConfiguration(ConfigurationUpdateRequest request) {
        block2: {
            ConfigurationServerService configurationServerService = this.getConfigurationServerService();
            try {
                ConfigManagement configMgmt = this.configMgmtFactory.getStrategy(request.getResourceId());
                ResourceType resourceType = this.componentService.getResourceType(request.getResourceId());
                UpdateResourceConfigurationRunner runnable = new UpdateResourceConfigurationRunner(configurationServerService, resourceType, configMgmt, request);
                this.getThreadPool().submit(runnable);
            }
            catch (PluginContainerException e) {
                this.log.error((Object)("Failed to submit config update task. Cause: " + (Object)((Object)e)));
                if (configurationServerService == null) break block2;
                ConfigurationUpdateResponse error = new ConfigurationUpdateResponse(request.getConfigurationUpdateId(), request.getConfiguration(), (Throwable)e);
                configurationServerService.completeConfigurationUpdate(error);
            }
        }
    }

    public ConfigurationUpdateResponse executeUpdateResourceConfigurationImmediately(ConfigurationUpdateRequest request) throws PluginContainerException {
        ConfigurationUpdateResponse response;
        try {
            ConfigurationServerService configurationServerService = this.getConfigurationServerService();
            ResourceType resourceType = this.getResourceType(request.getResourceId());
            LegacyConfigManagement configMgmt = new LegacyConfigManagement();
            configMgmt.setComponentService(this.componentService);
            UpdateResourceConfigurationRunner runner = new UpdateResourceConfigurationRunner(configurationServerService, resourceType, configMgmt, request);
            response = this.getThreadPool().submit(runner).get();
        }
        catch (Exception e) {
            throw new PluginContainerException("Error occurred in delete resource thread", (Throwable)e);
        }
        return response;
    }

    public Configuration merge(Configuration configuration, int resourceId, boolean fromStructured) throws PluginContainerException {
        boolean daemonOnly = true;
        boolean onlyIfStarted = true;
        ResourceConfigurationFacet facet = this.componentService.getComponent(resourceId, ResourceConfigurationFacet.class, FacetLockType.READ, 60000L, daemonOnly, onlyIfStarted);
        if (fromStructured) {
            this.mergedStructuredIntoRaws(configuration, facet);
        } else {
            this.mergeRawsIntoStructured(configuration, facet);
        }
        return configuration;
    }

    private void mergeRawsIntoStructured(Configuration configuration, ResourceConfigurationFacet facet) {
        Configuration structuredConfig = facet.loadStructuredConfiguration();
        if (structuredConfig != null) {
            this.prepareConfigForMergeIntoStructured(configuration, structuredConfig);
            for (RawConfiguration rawConfig : configuration.getRawConfigurations()) {
                String contents = rawConfig.getContents();
                String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
                rawConfig.setContents(contents, sha256);
                structuredConfig.addRawConfiguration(rawConfig);
                facet.mergeStructuredConfiguration(rawConfig, configuration);
            }
        }
    }

    private void prepareConfigForMergeIntoStructured(Configuration config, Configuration latestStructured) {
        config.getAllProperties().clear();
        for (Property property : latestStructured.getProperties()) {
            config.put(property);
        }
    }

    private void mergedStructuredIntoRaws(Configuration configuration, ResourceConfigurationFacet facet) {
        Set rawConfigs = facet.loadRawConfigurations();
        if (rawConfigs == null) {
            return;
        }
        this.prepareConfigForMergeIntoRaws(configuration, rawConfigs);
        LinkedList queue = new LinkedList(rawConfigs);
        while (!queue.isEmpty()) {
            RawConfiguration originalRaw = (RawConfiguration)queue.poll();
            RawConfiguration mergedRaw = facet.mergeRawConfiguration(configuration, originalRaw);
            if (mergedRaw == null) continue;
            String contents = mergedRaw.getContents();
            String sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(contents);
            mergedRaw.setContents(contents, sha256);
            this.updateRawConfig(configuration, originalRaw, mergedRaw);
        }
    }

    private void prepareConfigForMergeIntoRaws(Configuration config, Set<RawConfiguration> latestRaws) {
        config.getRawConfigurations().clear();
        for (RawConfiguration raw : latestRaws) {
            config.addRawConfiguration(raw);
        }
    }

    private void updateRawConfig(Configuration configuration, RawConfiguration originalRaw, RawConfiguration mergedRaw) {
        configuration.removeRawConfiguration(originalRaw);
        configuration.addRawConfiguration(mergedRaw);
    }

    public Configuration loadResourceConfiguration(int resourceId) throws PluginContainerException {
        ConfigManagement loadConfig = this.configMgmtFactory.getStrategy(resourceId);
        Configuration configuration = null;
        try {
            configuration = loadConfig.executeLoad(resourceId);
        }
        catch (Throwable t) {
            throw new PluginContainerException(this.createErrorMsg(resourceId, "An exception was thrown."), t);
        }
        if (configuration == null) {
            throw new PluginContainerException(this.createErrorMsg(resourceId, "returned a null Configuration."));
        }
        return configuration;
    }

    private String createErrorMsg(int resourceId, String msg) throws PluginContainerException {
        ResourceType resourceType = this.componentService.getResourceType(resourceId);
        return "Plugin Error: Resource Component for [" + resourceType.getName() + "] Resource with id [" + resourceId + "]: " + msg;
    }

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    void setThreadPool(ScheduledExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    protected ConfigurationFacet getConfigurationFacet(int resourceId, FacetLockType lockType) throws PluginContainerException {
        boolean daemonThread = lockType != FacetLockType.WRITE;
        return ComponentUtil.getComponent(resourceId, ConfigurationFacet.class, lockType, 60000L, daemonThread, true);
    }

    protected ResourceType getResourceType(int resourceId) throws PluginContainerException {
        return ComponentUtil.getResourceType(resourceId);
    }

    protected ConfigurationServerService getConfigurationServerService() {
        if (this.pluginContainerConfiguration.getServerServices() != null) {
            return this.pluginContainerConfiguration.getServerServices().getConfigurationServerService();
        }
        return null;
    }

    public Configuration validate(Configuration configuration, int resourceId, boolean isStructured) throws PluginContainerException {
        boolean success = true;
        boolean daemonOnly = true;
        boolean onlyIfStarted = true;
        ResourceConfigurationFacet facet = this.componentService.getComponent(resourceId, ResourceConfigurationFacet.class, FacetLockType.READ, 60000L, daemonOnly, onlyIfStarted);
        if (isStructured) {
            try {
                facet.validateStructuredConfiguration(configuration);
            }
            catch (IllegalArgumentException e) {
                success = false;
            }
            catch (Throwable t) {
                throw new PluginContainerException(t.getMessage(), t);
            }
        } else {
            for (RawConfiguration rawConfiguration : configuration.getRawConfigurations()) {
                try {
                    facet.validateRawConfiguration(rawConfiguration);
                }
                catch (IllegalArgumentException e) {
                    success = false;
                    rawConfiguration.errorMessage = e.getMessage();
                }
                catch (Throwable t) {
                    success = false;
                    rawConfiguration.errorMessage = t.getMessage();
                }
            }
        }
        return success ? null : configuration;
    }
}

