/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.GET;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.cache.BrowserCache;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.ClientExecutionContext;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.WeightedMediaType;

public class CacheInterceptor
implements ClientExecutionInterceptor,
AcceptedByMethod {
    protected BrowserCache cache;

    public CacheInterceptor(BrowserCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean accept(Class declaring, Method method) {
        if (declaring == null || method == null) {
            return true;
        }
        return method.isAnnotationPresent(GET.class);
    }

    @Override
    public ClientResponse execute(ClientExecutionContext ctx) throws Exception {
        ClientRequest request = ctx.getRequest();
        if (!request.getHttpMethod().equals("GET")) {
            return ctx.proceed();
        }
        BrowserCache.Entry entry = this.getEntry(request);
        if (entry == null) {
            return this.cache(request, ctx.proceed());
        }
        if (entry.expired()) {
            BrowserCache.Header[] headers;
            this.cache.remove(request.getUri(), entry.getMediaType());
            for (BrowserCache.Header header : headers = entry.getValidationHeaders()) {
                request.header(header.getName(), header.getValue());
            }
            return this.handleExpired(ctx, request, entry);
        }
        return this.createClientResponse(request, entry);
    }

    protected ClientResponse handleExpired(ClientExecutionContext ctx, ClientRequest request, BrowserCache.Entry entry) throws Exception {
        ClientResponse response = ctx.proceed();
        if (response.getStatus() == Response.Status.NOT_MODIFIED.getStatusCode()) {
            return this.updateOnNotModified(request, entry, (BaseClientResponse)response);
        }
        return this.cache(request, response);
    }

    private ClientResponse cache(ClientRequest request, ClientResponse response) throws Exception {
        if (response.getStatus() != 200) {
            return response;
        }
        return this.cacheIfPossible(request, (BaseClientResponse)response);
    }

    public ClientResponse updateOnNotModified(ClientRequest request, BrowserCache.Entry old, BaseClientResponse response) throws Exception {
        old.getHeaders().remove((Object)"Cache-Control");
        old.getHeaders().remove((Object)"Expires");
        old.getHeaders().remove((Object)"Last-Modified");
        String cc = (String)response.getHeaders().getFirst((Object)"Cache-Control");
        String exp = (String)response.getHeaders().getFirst((Object)"Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                return this.createClientResponse(request, old);
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        if (cc != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)cc);
        }
        if (exp != null) {
            old.getHeaders().putSingle((Object)"Cache-Control", (Object)exp);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        String etag = (String)response.getHeaders().getFirst((Object)"ETag");
        if (etag == null) {
            etag = (String)old.getHeaders().getFirst((Object)"ETag");
        } else {
            old.getHeaders().putSingle((Object)"ETag", (Object)etag);
        }
        if (lastModified != null) {
            old.getHeaders().putSingle((Object)"Last-Modified", (Object)lastModified);
        }
        if (etag == null && lastModified == null && cc == null && exp == null) {
            return this.createClientResponse(request, old);
        }
        BrowserCache.Entry entry = this.cache.put(request.getUri(), old.getMediaType(), old.getHeaders(), old.getCached(), expires, etag, lastModified);
        return this.createClientResponse(request, entry);
    }

    private BaseClientResponse createClientResponse(ClientRequest request, BrowserCache.Entry entry) {
        BaseClientResponse response = new BaseClientResponse(new CachedStreamFactory(entry));
        response.setStatus(200);
        response.setHeaders(entry.getHeaders());
        response.setProviderFactory(request.getProviderFactory());
        return response;
    }

    public ClientResponse cacheIfPossible(ClientRequest request, BaseClientResponse response) throws Exception {
        String cc = (String)response.getHeaders().getFirst((Object)"Cache-Control");
        String exp = (String)response.getHeaders().getFirst((Object)"Expires");
        int expires = -1;
        if (cc != null) {
            CacheControl cacheControl = CacheControl.valueOf((String)cc);
            if (cacheControl.isNoCache()) {
                return response;
            }
            expires = cacheControl.getMaxAge();
        } else if (exp != null) {
            Date date = DateUtil.parseDate(exp);
            expires = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
        }
        String lastModified = (String)response.getHeaders().getFirst((Object)"Last-Modified");
        String etag = (String)response.getHeaders().getFirst((Object)"ETag");
        String contentType = (String)response.getHeaders().getFirst((Object)"Content-Type");
        byte[] cached = ReadFromStream.readFromStream(1024, response.getStreamFactory().getInputStream());
        response.getStreamFactory().performReleaseConnection();
        MediaType mediaType = MediaType.valueOf((String)contentType);
        BrowserCache.Entry entry = this.cache.put(request.getUri(), mediaType, response.getHeaders(), cached, expires, etag, lastModified);
        response.setStreamFactory(new CachedStreamFactory(entry));
        return response;
    }

    protected BrowserCache.Entry getEntry(ClientRequest request) throws Exception {
        String uri = request.getUri();
        BrowserCache.Entry entry = null;
        String acceptHeader = (String)request.getHeaders().getFirst((Object)"Accept");
        if (acceptHeader != null) {
            String[] split;
            ArrayList<WeightedMediaType> waccepts = new ArrayList<WeightedMediaType>();
            for (String accept : split = acceptHeader.split(",")) {
                waccepts.add(WeightedMediaType.valueOf(accept));
            }
            Collections.sort(waccepts);
            ArrayList<MediaType> accepts = new ArrayList<MediaType>();
            for (WeightedMediaType accept : waccepts) {
                accepts.add(new MediaType(accept.getType(), accept.getSubtype(), accept.getParameters()));
            }
            for (MediaType accept : accepts) {
                entry = this.cache.get(uri, accept);
                if (entry == null) continue;
                return entry;
            }
        } else {
            return this.cache.getAny(uri);
        }
        return null;
    }

    static class CachedStreamFactory
    implements BaseClientResponse.BaseClientResponseStreamFactory {
        BrowserCache.Entry entry;

        public CachedStreamFactory(BrowserCache.Entry entry) {
            this.entry = entry;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.entry.getCached());
        }

        @Override
        public void performReleaseConnection() {
        }
    }
}

