/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.deployer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.ejb.TimerConfig;
import org.jboss.beans.metadata.api.annotations.Install;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.timeout.spi.TimeoutMethodCallbackRequirements;
import org.jboss.ejb3.timerservice.extension.TimerService;
import org.jboss.ejb3.util.Service;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBean31MetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class AutoTimerInitializer {
    private static Logger logger = Logger.getLogger(AutoTimerInitializer.class);
    private static TimeoutMethodCallbackRequirements timeoutMethodCallbackRequirements = (TimeoutMethodCallbackRequirements)Service.loadService(TimeoutMethodCallbackRequirements.class);

    @Install(dependentState="Start")
    public void initializeAutoTimers(EJBContainer container) {
        JBossEnterpriseBeanMetaData enterpriseBeanMetaData = container.getXml();
        if (!enterpriseBeanMetaData.getJBossMetaData().isEJB31()) {
            return;
        }
        List autoTimersMetaData = null;
        if (enterpriseBeanMetaData.isSession() && enterpriseBeanMetaData instanceof JBossSessionBean31MetaData) {
            JBossSessionBean31MetaData sessionBean = (JBossSessionBean31MetaData)enterpriseBeanMetaData;
            if (sessionBean.isStateful()) {
                return;
            }
            autoTimersMetaData = sessionBean.getTimers();
        } else if (enterpriseBeanMetaData.isMessageDriven() && enterpriseBeanMetaData instanceof JBossMessageDrivenBean31MetaData) {
            JBossMessageDrivenBean31MetaData mdb = (JBossMessageDrivenBean31MetaData)enterpriseBeanMetaData;
            autoTimersMetaData = mdb.getTimers();
        }
        if (autoTimersMetaData == null) {
            return;
        }
        javax.ejb.TimerService timerService = container.getTimerService();
        if (!(timerService instanceof TimerService)) {
            logger.warn((Object)("Cannot create auto timers for EJB: " + enterpriseBeanMetaData.getEjbName() + " since the timerservice isn't of type " + TimerService.class.getName()));
            return;
        }
        TimerService ejb31TimerService = (TimerService)timerService;
        for (TimerMetaData autoTimerMetaData : autoTimersMetaData) {
            NamedMethodMetaData timeoutMethodMetaData;
            Method timeoutMethod;
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setPersistent(autoTimerMetaData.isPersistent());
            String info = autoTimerMetaData.getInfo();
            if (info != null && !info.isEmpty()) {
                timerConfig.setInfo((Serializable)((Object)autoTimerMetaData.getInfo()));
            }
            if ((timeoutMethod = this.getTimeoutMethod(timeoutMethodMetaData = autoTimerMetaData.getTimeoutMethod(), container.getBeanClass())) == null) {
                StringBuilder methodStringBuilder = new StringBuilder();
                methodStringBuilder.append(timeoutMethodMetaData.getMethodName());
                if (timeoutMethodMetaData.getMethodParams() != null) {
                    methodStringBuilder.append(Arrays.toString(timeoutMethodMetaData.getMethodParams().toArray()));
                }
                throw new IllegalStateException("Timeout method: " + methodStringBuilder.toString() + " not found for bean class: " + enterpriseBeanMetaData.getEjbClass());
            }
            ejb31TimerService.getAutoTimer(autoTimerMetaData.getScheduleExpression(), timerConfig, timeoutMethod);
        }
    }

    private Method getTimeoutMethod(NamedMethodMetaData timeoutMethodMetaData, Class<?> beanClass) {
        String timeoutMethodName = timeoutMethodMetaData.getMethodName();
        MethodParametersMetaData timeoutMethodParams = timeoutMethodMetaData.getMethodParams();
        Class[] timeoutMethodParamTypes = null;
        if (timeoutMethodParams != null) {
            timeoutMethodParamTypes = new Class[timeoutMethodParams.size()];
            int i = 0;
            for (String paramClassName : timeoutMethodParams) {
                Class<?> methodParamClass = null;
                try {
                    methodParamClass = Class.forName(paramClassName, false, beanClass.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Could not load method param class: " + paramClassName + " of timeout method");
                }
                timeoutMethodParamTypes[i++] = methodParamClass;
            }
        }
        return timeoutMethodCallbackRequirements.getTimeoutMethod(beanClass, timeoutMethodName, timeoutMethodParamTypes);
    }
}

