/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.common.OptionalDontShowMeAgainDialog;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CutNodeAction;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.PasteAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class CutAction
extends AbstractAction
implements ActorXml {
    private String text;
    private final MindMapController mMindMapController;
    private static Logger logger = null;

    public CutAction(MindMapController c) {
        super(c.getText("cut"), new ImageIcon(c.getResource("images/editcut.png")));
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mMindMapController = c;
        this.text = c.getText("cut");
        this.setEnabled(false);
        this.mMindMapController.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.mMindMapController.getView().getRoot().isSelected()) {
            this.mMindMapController.getController().errorMessage(this.mMindMapController.getFrame().getResourceString("cannot_delete_root"));
            return;
        }
        int showResult = new OptionalDontShowMeAgainDialog(this.mMindMapController.getFrame().getJFrame(), this.mMindMapController.getSelectedView(), "really_cut_node", "confirmation", this.mMindMapController, new OptionalDontShowMeAgainDialog.StandardPropertyHandler(this.mMindMapController.getController(), "resources_cut_nodes_without_question"), 0).show().getResult();
        if (showResult != 0) {
            return;
        }
        Transferable copy = this.mMindMapController.cut();
        this.mMindMapController.setClipboardContents(copy);
        this.mMindMapController.getController().obtainFocusForSelected();
    }

    public CutNodeAction getCutNodeAction(MindMapNode node) {
        CutNodeAction cutAction = new CutNodeAction();
        cutAction.setNode(this.mMindMapController.getNodeID(node));
        return cutAction;
    }

    public Transferable cut(List nodeList) {
        this.mMindMapController.sortNodesByDepth(nodeList);
        Transferable totalCopy = this.mMindMapController.copy(nodeList, true);
        CompoundAction doAction = new CompoundAction();
        CompoundAction undo = new CompoundAction();
        Iterator i = nodeList.iterator();
        while (i.hasNext()) {
            MindMapNode node = (MindMapNode)i.next();
            if (node.getParentNode() == null) continue;
            CutNodeAction cutNodeAction = this.getCutNodeAction(node);
            doAction.addChoice((Object)cutNodeAction);
            PasteAction.NodeCoordinate coord = new PasteAction.NodeCoordinate(node, node.isLeft());
            Transferable copy = this.mMindMapController.copy(node, true);
            PasteNodeAction pasteNodeAction = this.mMindMapController.paste.getPasteNodeAction(copy, coord);
            logger.info("Undo for cut: " + this.mMindMapController.marshall((XmlAction)pasteNodeAction));
            undo.addAtChoice(0, (Object)pasteNodeAction);
        }
        if (doAction.sizeChoiceList() > 0) {
            this.mMindMapController.getActionFactory().startTransaction(this.text);
            this.mMindMapController.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undo));
            this.mMindMapController.getActionFactory().endTransaction(this.text);
        }
        return totalCopy;
    }

    public void act(XmlAction action) {
        CutNodeAction cutAction = (CutNodeAction)action;
        this.mMindMapController.getModel().getLinkRegistry().clearCuttedNodeBuffer();
        NodeAdapter selectedNode = this.mMindMapController.getNodeFromID(cutAction.getNode());
        this.mMindMapController.getModel().getLinkRegistry().cutNode(selectedNode);
        this.mMindMapController.deleteChild.deleteWithoutUndo(selectedNode);
    }

    public Class getDoActionClass() {
        return CutNodeAction.class;
    }
}

