/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.xpcom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIComponentRegistrar;
import org.mozilla.interfaces.nsILocalFile;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.GREVersionRange;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.IGRE;
import org.mozilla.xpcom.IJavaXPCOMUtils;
import org.mozilla.xpcom.IMozilla;
import org.mozilla.xpcom.INIParser;
import org.mozilla.xpcom.IXPCOM;
import org.mozilla.xpcom.IXPCOMError;
import org.mozilla.xpcom.IXREAppData;
import org.mozilla.xpcom.ProfileLock;
import org.mozilla.xpcom.XPCOMException;
import org.mozilla.xpcom.XPCOMInitializationException;

public class Mozilla
implements IMozilla,
IGRE,
IXPCOM,
IJavaXPCOMUtils,
IXPCOMError {
    private static Mozilla mozillaInstance = new Mozilla();
    private static final String JAVAXPCOM_JAR = "javaxpcom.jar";
    private IMozilla mozilla = null;
    private IGRE gre = null;
    private IXPCOM xpcom = null;
    private IJavaXPCOMUtils jxutils = null;

    public static Mozilla getInstance() {
        return mozillaInstance;
    }

    private Mozilla() {
    }

    public static File getGREPathWithProperties(GREVersionRange[] gREVersionRangeArray, Properties properties) throws FileNotFoundException {
        File file = null;
        String string = System.getProperty("GRE_HOME");
        if (string != null) {
            try {
                file = new File(string).getCanonicalFile();
            }
            catch (IOException iOException) {
                throw new FileNotFoundException("cannot access GRE_HOME");
            }
            if (!file.exists()) {
                throw new FileNotFoundException("GRE_HOME doesn't exist");
            }
            return file;
        }
        string = System.getProperty("USE_LOCAL_GRE");
        if (string != null) {
            return null;
        }
        if (properties == null) {
            properties = new Properties();
        }
        properties.setProperty("javaxpcom", "1");
        String string2 = System.getProperty("os.name").toLowerCase();
        file = string2.startsWith("mac os x") ? Mozilla.getGREPathMacOSX(gREVersionRangeArray) : (string2.startsWith("windows") ? Mozilla.getGREPathWindows(gREVersionRangeArray, properties) : Mozilla.getGREPathUnix(gREVersionRangeArray, properties));
        if (file == null) {
            throw new FileNotFoundException("GRE not found");
        }
        return file;
    }

    private static File getGREPathMacOSX(GREVersionRange[] gREVersionRangeArray) {
        File file = Mozilla.findGREBundleFramework();
        if (file != null) {
            return file;
        }
        String string = System.getProperty("user.home");
        if (string != null && (file = Mozilla.findGREFramework(string, gREVersionRangeArray)) != null) {
            return file;
        }
        return Mozilla.findGREFramework("", gREVersionRangeArray);
    }

    private static File findGREBundleFramework() {
        try {
            File file;
            File file2;
            File file3;
            File file4;
            Method method;
            String string;
            URL[] uRLArray = new URL[]{new File("/System/Library/Java/").toURL()};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = Class.forName("com.apple.cocoa.foundation.NSBundle", true, uRLClassLoader);
            Method method2 = clazz.getMethod("mainBundle", null);
            Object object = method2.invoke(null, null);
            if (object != null && (string = (String)(method = clazz.getMethod("privateFrameworksPath", null)).invoke(object, null)).length() != 0 && (file4 = new File(string, "XUL.framework")).isDirectory() && (file3 = new File(file4, "libxpcom.dylib")).canRead() && (file2 = new File(file = file3.getCanonicalFile().getParentFile(), JAVAXPCOM_JAR)).canRead()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static File findGREFramework(String string, GREVersionRange[] gREVersionRangeArray) {
        File file = new File(string + "/Library/Frameworks/XUL.framework/Versions");
        if (!file.exists()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!Mozilla.checkVersion(fileArray[i].getName(), gREVersionRangeArray)) continue;
            File file2 = new File(fileArray[i], "libxpcom.dylib");
            File file3 = new File(fileArray[i], JAVAXPCOM_JAR);
            if (!file2.canRead() || !file3.canRead()) continue;
            return fileArray[i];
        }
        return null;
    }

    private static File getGREPathWindows(GREVersionRange[] gREVersionRangeArray, Properties properties) {
        String string = "HKEY_CURRENT_USER\\Software\\mozilla.org\\GRE";
        File file = Mozilla.getGREPathFromRegKey(string, gREVersionRangeArray, properties);
        if (file == null) {
            string = "HKEY_LOCAL_MACHINE\\Software\\mozilla.org\\GRE";
            file = Mozilla.getGREPathFromRegKey(string, gREVersionRangeArray, properties);
        }
        return file;
    }

    private static File getGREPathFromRegKey(String string, GREVersionRange[] gREVersionRangeArray, Properties properties) {
        File file;
        try {
            file = File.createTempFile("jx_registry", null);
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            Process process = Runtime.getRuntime().exec("regedit /e \"" + file.getPath() + "\" \"" + string + "\"");
            process.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file2 = null;
        if (file.length() != 0L) {
            file2 = Mozilla.getGREPathFromRegistryFile(file.getPath(), string, gREVersionRangeArray, properties);
        }
        file.delete();
        return file2;
    }

    private static File getGREPathFromRegistryFile(String string, String string2, GREVersionRange[] gREVersionRangeArray, Properties properties) {
        INIParser iNIParser;
        try {
            iNIParser = new INIParser(string, Charset.forName("UTF-16"));
        }
        catch (Exception exception) {
            return null;
        }
        Iterator iterator = iNIParser.getSections();
        while (iterator.hasNext()) {
            String string3;
            Object object;
            Object object2;
            String string4;
            String string5;
            String string6 = (String)iterator.next();
            int n = string2.length();
            if (string6.length() <= n || (string5 = string6.substring(n + 1)).indexOf(92) != -1 || (string4 = iNIParser.getString(string6, "\"Version\"")) == null || !Mozilla.checkVersion(string4 = string4.substring(1, string4.length() - 1), gREVersionRangeArray)) continue;
            if (properties != null) {
                boolean bl = true;
                object2 = properties.propertyNames();
                while (bl && object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    String string7 = iNIParser.getString(string6, "\"" + (String)object + "\"");
                    if (string7 == null) {
                        bl = false;
                        continue;
                    }
                    String string8 = properties.getProperty((String)object);
                    if (string7.equals("\"" + string8 + "\"")) continue;
                    bl = false;
                }
                if (!bl) continue;
            }
            if ((string3 = iNIParser.getString(string6, "\"GreHome\"")) == null || !((File)(object2 = new File(string3 = string3.substring(1, string3.length() - 1)))).exists() || !((File)(object = new File((File)object2, "xpcom.dll"))).canRead()) continue;
            return object2;
        }
        return null;
    }

    private static File getGREPathUnix(GREVersionRange[] gREVersionRangeArray, Properties properties) {
        File file = null;
        String string = System.getProperty("MOZ_GRE_CONF");
        if (string != null && (file = Mozilla.getPathFromConfigFile(string, gREVersionRangeArray, properties)) != null) {
            return file;
        }
        string = System.getProperty("user.home");
        if (string != null) {
            file = Mozilla.getPathFromConfigFile(string + File.separator + ".gre.config", gREVersionRangeArray, properties);
            if (file != null) {
                return file;
            }
            file = Mozilla.getPathFromConfigDir(string + File.separator + ".gre.d", gREVersionRangeArray, properties);
            if (file != null) {
                return file;
            }
        }
        if ((file = Mozilla.getPathFromConfigFile("/etc/gre.conf", gREVersionRangeArray, properties)) != null) {
            return file;
        }
        file = Mozilla.getPathFromConfigDir("/etc/gre.d", gREVersionRangeArray, properties);
        return file;
    }

    private static File getPathFromConfigFile(String string, GREVersionRange[] gREVersionRangeArray, Properties properties) {
        INIParser iNIParser;
        try {
            iNIParser = new INIParser(string);
        }
        catch (Exception exception) {
            return null;
        }
        Iterator iterator = iNIParser.getSections();
        while (iterator.hasNext()) {
            String string2;
            Object object;
            Object object2;
            String string3 = (String)iterator.next();
            if (!Mozilla.checkVersion(string3, gREVersionRangeArray)) continue;
            if (properties != null) {
                boolean bl = true;
                object2 = properties.propertyNames();
                while (bl && object2.hasMoreElements()) {
                    object = (String)object2.nextElement();
                    String string4 = iNIParser.getString(string3, (String)object);
                    if (string4 == null) {
                        bl = false;
                        continue;
                    }
                    if (string4.equals(properties.getProperty((String)object))) continue;
                    bl = false;
                }
                if (!bl) continue;
            }
            if ((string2 = iNIParser.getString(string3, "GRE_PATH")) == null || !((File)(object2 = new File(string2))).exists() || !((File)(object = new File((File)object2, "libxpcom.so"))).canRead()) continue;
            return object2;
        }
        return null;
    }

    private static File getPathFromConfigDir(String string, GREVersionRange[] gREVersionRangeArray, Properties properties) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return null;
        }
        File file2 = null;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length && file2 == null; ++i) {
            if (!fileArray[i].getName().endsWith(".conf")) continue;
            file2 = Mozilla.getPathFromConfigFile(fileArray[i].getPath(), gREVersionRangeArray, properties);
        }
        return file2;
    }

    private static boolean checkVersion(String string, GREVersionRange[] gREVersionRangeArray) {
        for (int i = 0; i < gREVersionRangeArray.length; ++i) {
            if (!gREVersionRangeArray[i].check(string)) continue;
            return true;
        }
        return false;
    }

    public void initialize(File file) throws XPCOMInitializationException {
        File file2 = new File(file, JAVAXPCOM_JAR);
        if (!file2.exists()) {
            throw new XPCOMInitializationException("Could not find javaxpcom.jar in " + file);
        }
        URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = file2.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPCOMInitializationException(malformedURLException);
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
        try {
            Class<?> clazz = Class.forName("org.mozilla.xpcom.internal.MozillaImpl", true, uRLClassLoader);
            this.mozilla = (IMozilla)clazz.newInstance();
            Class<?> clazz2 = Class.forName("org.mozilla.xpcom.internal.GREImpl", true, uRLClassLoader);
            this.gre = (IGRE)clazz2.newInstance();
            Class<?> clazz3 = Class.forName("org.mozilla.xpcom.internal.XPCOMImpl", true, uRLClassLoader);
            this.xpcom = (IXPCOM)clazz3.newInstance();
            Class<?> clazz4 = Class.forName("org.mozilla.xpcom.internal.JavaXPCOMMethods", true, uRLClassLoader);
            this.jxutils = (IJavaXPCOMUtils)clazz4.newInstance();
        }
        catch (Exception exception) {
            throw new XPCOMInitializationException("Could not load org.mozilla.xpcom.internal.* classes", exception);
        }
        this.mozilla.initialize(file);
    }

    public void initEmbedding(File file, File file2, IAppFileLocProvider iAppFileLocProvider, IXREAppData iXREAppData) throws XPCOMException {
        try {
            this.gre.initEmbedding(file, file2, iAppFileLocProvider, iXREAppData);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public void termEmbedding() {
        try {
            try {
                this.gre.termEmbedding();
            }
            catch (NullPointerException nullPointerException) {
                throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
            }
            Object var3_1 = null;
            this.mozilla = null;
            this.gre = null;
            this.xpcom = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.mozilla = null;
            this.gre = null;
            this.xpcom = null;
            throw throwable;
        }
    }

    public ProfileLock lockProfileDirectory(File file) throws XPCOMException {
        try {
            return this.gre.lockProfileDirectory(file);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public void notifyProfile() {
        try {
            this.gre.notifyProfile();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIServiceManager initXPCOM(File file, IAppFileLocProvider iAppFileLocProvider) throws XPCOMException {
        try {
            return this.xpcom.initXPCOM(file, iAppFileLocProvider);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public void shutdownXPCOM(nsIServiceManager nsIServiceManager2) throws XPCOMException {
        try {
            try {
                this.xpcom.shutdownXPCOM(nsIServiceManager2);
            }
            catch (NullPointerException nullPointerException) {
                throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
            }
            Object var4_2 = null;
            this.mozilla = null;
            this.gre = null;
            this.xpcom = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.mozilla = null;
            this.gre = null;
            this.xpcom = null;
            throw throwable;
        }
    }

    public nsIServiceManager getServiceManager() throws XPCOMException {
        try {
            return this.xpcom.getServiceManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIComponentManager getComponentManager() throws XPCOMException {
        try {
            return this.xpcom.getComponentManager();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsIComponentRegistrar getComponentRegistrar() throws XPCOMException {
        try {
            return this.xpcom.getComponentRegistrar();
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public nsILocalFile newLocalFile(String string, boolean bl) throws XPCOMException {
        try {
            return this.xpcom.newLocalFile(string, bl);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public static nsISupports queryInterface(nsISupports nsISupports2, String string) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(nsISupports2.getClass());
        while (!arrayList.isEmpty()) {
            Object object;
            Class clazz = (Class)arrayList.remove(0);
            String string2 = clazz.getName();
            if (string2.startsWith("java.") || string2.startsWith("javax.")) continue;
            if (clazz.isInterface() && string2.startsWith("org.mozilla") && (object = Mozilla.getInterfaceIID(clazz)) != null && string.equals(object)) {
                return nsISupports2;
            }
            object = clazz.getInterfaces();
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                arrayList.add(object[i]);
            }
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) continue;
            arrayList.add(clazz2);
        }
        return null;
    }

    public static String getInterfaceIID(Class clazz) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = clazz.getName();
        int n = string3.lastIndexOf(".");
        String string4 = string2 = n > 0 ? string3.substring(n + 1) : string3;
        if (string2.startsWith("ns")) {
            stringBuffer.append("NS_");
            stringBuffer.append(string2.substring(2).toUpperCase());
        } else {
            stringBuffer.append(string2.toUpperCase());
        }
        stringBuffer.append("_IID");
        try {
            Field field = clazz.getDeclaredField(stringBuffer.toString());
            string = (String)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("ERROR: Could not get field " + stringBuffer.toString());
            string = null;
        }
        return string;
    }

    public long getNativeHandleFromAWT(Object object) {
        try {
            return this.mozilla.getNativeHandleFromAWT(object);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public long wrapJavaObject(Object object, String string) {
        try {
            return this.jxutils.wrapJavaObject(object, string);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }

    public Object wrapXPCOMObject(long l, String string) {
        try {
            return this.jxutils.wrapXPCOMObject(l, string);
        }
        catch (NullPointerException nullPointerException) {
            throw new XPCOMInitializationException("Must call Mozilla.getInstance().initialize() before using this method", nullPointerException);
        }
    }
}

