/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.mozilla.browser.impl.components.JMultiLineLabel;
import org.mozilla.browser.mt;

public class JUsernamePasswordDialog
extends JDialog {
    private static final long serialVersionUID = 3492572931924246920L;
    private JTextField tfUsername;
    private JPasswordField tfPassword;
    private JCheckBox chkMessage;
    private JButton btOk;
    private JButton btCancel;
    private EventsHandler eventsHandler = new EventsHandler();
    private boolean retVal = false;

    public JUsernamePasswordDialog(Frame parent, String title, String message, String initialUsername, String initialPassword, boolean addCheck, String checkMessage, boolean initialCheckState) {
        super(parent, title, true);
        this.init(parent, message, true, initialUsername, initialPassword, addCheck, checkMessage, initialCheckState);
    }

    public JUsernamePasswordDialog(Frame parent, String title, String message, String initialPassword, boolean addCheck, String checkMessage, boolean initialCheckState) {
        super(parent, title, true);
        this.init(parent, message, false, "", initialPassword, addCheck, checkMessage, initialCheckState);
    }

    private void init(Frame parent, String text, boolean addUsername, String initialUsername, String initialPassword, boolean addCheck, String checkMessage, boolean initialCheck) {
        JPanel p2;
        this.setDefaultCloseOperation(2);
        JPanel box = new JPanel();
        Border b = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        box.setBorder(b);
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        int x = 0;
        int y = 0;
        Insets topSpace = new Insets(7, 0, 0, 0);
        Insets top2Space = new Insets(10, 0, 0, 0);
        Insets top3Space = new Insets(20, 0, 0, 0);
        c.weightx = 1.0;
        JPanel p1 = this.createMessagePanel(text);
        c.gridx = x++;
        c.gridy = y++;
        c.insets = topSpace;
        box.add((Component)p1, c);
        x = 0;
        if (addUsername) {
            p2 = this.createUsernamePanel(initialUsername);
            c.gridx = x++;
            c.gridy = y++;
            c.insets = topSpace;
            box.add((Component)p2, c);
            x = 0;
        }
        p2 = this.createPasswordPanel(initialPassword);
        c.gridx = x++;
        c.gridy = y++;
        c.insets = topSpace;
        box.add((Component)p2, c);
        x = 0;
        if (addCheck) {
            JPanel p3 = this.createCheckPanel(checkMessage, initialCheck);
            c.gridx = x++;
            c.gridy = y++;
            c.insets = top2Space;
            box.add((Component)p3, c);
            x = 0;
        }
        JPanel p4 = this.createButtonsPanel();
        c.gridx = x++;
        c.gridy = y++;
        c.insets = top3Space;
        box.add((Component)p4, c);
        x = 0;
        this.setContentPane(box);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setResizable(false);
        JRootPane rp = this.getRootPane();
        rp.setDefaultButton(this.btOk);
        if (addUsername) {
            this.tfUsername.grabFocus();
        } else {
            this.tfPassword.grabFocus();
        }
    }

    private JPanel createMessagePanel(String message) {
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        int x = 0;
        int y = 0;
        Insets nullSpace = new Insets(0, 0, 0, 0);
        Insets leftSpace = new Insets(0, 5, 0, 0);
        JLabel lb = new JLabel(UIManager.getIcon("OptionPane.questionIcon"));
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = nullSpace;
        box.add((Component)lb, c);
        JMultiLineLabel ml = new JMultiLineLabel();
        ml.setText(message);
        JScrollPane spMessage = new JScrollPane(ml);
        spMessage.setHorizontalScrollBarPolicy(31);
        spMessage.setBorder(null);
        c.gridx = x++;
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = leftSpace;
        box.add((Component)spMessage, c);
        x = 0;
        return box;
    }

    private JPanel createUsernamePanel(String username) {
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        int x = 0;
        int y = 0;
        Insets nullSpace = new Insets(0, 0, 0, 0);
        Insets leftSpace = new Insets(0, 5, 0, 0);
        JLabel lbUsername = new JLabel(mt.t("JUsernamePasswordDialog.Username"));
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = nullSpace;
        box.add((Component)lbUsername, c);
        this.tfUsername = new JTextField();
        this.tfUsername.setText(username);
        this.tfUsername.setSelectionStart(0);
        this.tfUsername.setSelectionEnd(username.length());
        Dimension d = this.tfUsername.getPreferredSize();
        d.width = 150;
        this.tfUsername.setPreferredSize(d);
        c.gridx = x++;
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = leftSpace;
        box.add((Component)this.tfUsername, c);
        x = 0;
        return box;
    }

    private JPanel createPasswordPanel(String password) {
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        int x = 0;
        int y = 0;
        Insets nullSpace = new Insets(0, 0, 0, 0);
        Insets leftSpace = new Insets(0, 5, 0, 0);
        JLabel lbPassword = new JLabel(mt.t("JUsernamePasswordDialog.Password"));
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = nullSpace;
        box.add((Component)lbPassword, c);
        this.tfPassword = new JPasswordField();
        this.tfPassword.setText(password);
        this.tfPassword.setSelectionStart(0);
        this.tfPassword.setSelectionEnd(password.length());
        Dimension d = this.tfPassword.getPreferredSize();
        d.width = 150;
        this.tfPassword.setPreferredSize(d);
        c.gridx = x++;
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.insets = leftSpace;
        box.add((Component)this.tfPassword, c);
        x = 0;
        return box;
    }

    private JPanel createButtonsPanel() {
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        int x = 0;
        int y = 0;
        Insets nullSpace = new Insets(0, 0, 0, 0);
        Insets leftSpace = new Insets(0, 5, 0, 0);
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 1.0;
        c.insets = nullSpace;
        box.add(Box.createHorizontalGlue(), c);
        this.btOk = new JButton(mt.t("JUsernamePasswordDialog.Ok"));
        this.btOk.addActionListener(this.eventsHandler);
        Dimension d = this.btOk.getPreferredSize();
        d.width = 80;
        this.btOk.setPreferredSize(d);
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = nullSpace;
        box.add((Component)this.btOk, c);
        this.btCancel = new JButton(mt.t("JUsernamePasswordDialog.Cancel"));
        this.btCancel.addActionListener(this.eventsHandler);
        d = this.btCancel.getPreferredSize();
        d.width = 80;
        this.btCancel.setPreferredSize(d);
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 0.0;
        c.insets = leftSpace;
        box.add((Component)this.btCancel, c);
        c.gridx = x++;
        c.gridy = y++;
        c.weightx = 1.0;
        c.insets = nullSpace;
        box.add(Box.createHorizontalGlue(), c);
        x = 0;
        return box;
    }

    private JPanel createCheckPanel(String message, boolean checkState) {
        JPanel box = new JPanel();
        box.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        int x = 0;
        int y = 0;
        Insets nullSpace = new Insets(0, 0, 0, 0);
        this.chkMessage = new JCheckBox(message);
        this.chkMessage.setSelected(checkState);
        c.gridx = x++;
        c.gridy = y;
        c.weightx = 1.0;
        c.insets = nullSpace;
        box.add((Component)this.chkMessage, c);
        return box;
    }

    public boolean run() {
        this.setVisible(true);
        return this.retVal;
    }

    public boolean getRetVal() {
        return this.retVal;
    }

    public String getUsername() {
        if (this.tfUsername != null) {
            return "";
        }
        return this.tfUsername.getText();
    }

    public String getPassword() {
        return new String(this.tfPassword.getPassword());
    }

    public boolean getCheckState() {
        return this.chkMessage.isSelected();
    }

    class EventsHandler
    implements ActionListener {
        EventsHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == JUsernamePasswordDialog.this.btOk) {
                JUsernamePasswordDialog.this.retVal = true;
                JUsernamePasswordDialog.this.dispose();
            } else if (e.getSource() == JUsernamePasswordDialog.this.btCancel) {
                JUsernamePasswordDialog.this.retVal = true;
                JUsernamePasswordDialog.this.dispose();
            }
        }
    }
}

