/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.nosave;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.impl.feature.NoSave;
import org.limewire.friend.impl.feature.NoSaveFeature;
import org.limewire.friend.impl.feature.NoSaveStatus;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.xmpp.client.impl.XMPPFriendConnectionImpl;
import org.limewire.xmpp.client.impl.XMPPFriendImpl;
import org.limewire.xmpp.client.impl.messages.nosave.NoSaveIQ;

public class NoSaveIQListener
implements PacketListener {
    private final XMPPFriendConnectionImpl connection;
    private Map<String, NoSave> noSaveMap = new HashMap<String, NoSave>();
    private ListenerSupport<FriendPresenceEvent> friendPresenceSupport;
    private EventListener<FriendPresenceEvent> friendPresenceListener;

    private NoSaveIQListener(XMPPFriendConnectionImpl connection) {
        this.connection = connection;
    }

    public static NoSaveIQListener createNoSaveIQListener(XMPPFriendConnectionImpl connection, ListenerSupport<FriendPresenceEvent> friendPresenceSupport) {
        NoSaveIQListener noSaveIQListener = new NoSaveIQListener(connection);
        noSaveIQListener.register(friendPresenceSupport);
        return noSaveIQListener;
    }

    @Override
    public void processPacket(Packet packet) {
        NoSaveIQ noSave = (NoSaveIQ)packet;
        Map<String, NoSave> friends = noSave.getNoSaveUsers();
        this.updateNoSaveStatusMap(friends);
        for (String friendName : friends.keySet()) {
            XMPPFriendImpl noSaveFriend = this.connection.getFriend(friendName);
            if (noSaveFriend == null) continue;
            for (FriendPresence presence : noSaveFriend.getPresences().values()) {
                this.addNoSaveFeatureIfNecessary(presence, friends.get(friendName));
            }
        }
    }

    public PacketFilter getPacketFilter() {
        return new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                return packet instanceof NoSaveIQ;
            }
        };
    }

    public void cleanup() {
        this.friendPresenceSupport.removeListener(this.friendPresenceListener);
    }

    private void register(ListenerSupport<FriendPresenceEvent> friendPresenceSupport) {
        this.friendPresenceSupport = friendPresenceSupport;
        this.friendPresenceListener = new FriendPresenceListener();
        this.friendPresenceSupport.addListener(this.friendPresenceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNoSaveStatusMap(Map<String, NoSave> noSaveMap) {
        NoSaveIQListener noSaveIQListener = this;
        synchronized (noSaveIQListener) {
            this.noSaveMap = new HashMap<String, NoSave>(noSaveMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNewPresenceNoSave(FriendPresence presence) {
        NoSave noSaveStatus;
        String friendId = presence.getFriend().getId();
        NoSaveIQListener noSaveIQListener = this;
        synchronized (noSaveIQListener) {
            noSaveStatus = this.noSaveMap.get(friendId);
        }
        if (noSaveStatus != null) {
            this.addNoSaveFeatureIfNecessary(presence, noSaveStatus);
        }
    }

    private void addNoSaveFeatureIfNecessary(FriendPresence presence, NoSave nosave) {
        if (this.shouldAddFeature(presence, nosave)) {
            presence.addFeature(new NoSaveFeature(new NoSaveStatusImpl(nosave, presence.getFriend().getId())));
        }
    }

    private boolean shouldAddFeature(FriendPresence presence, NoSave nosave) {
        return !presence.hasFeatures(NoSaveFeature.ID) || nosave != ((NoSaveStatus)((NoSaveFeature)presence.getFeature(NoSaveFeature.ID)).getFeature()).getStatus();
    }

    private class NoSaveStatusImpl
    implements NoSaveStatus {
        private final NoSave noSave;
        private final String userName;

        NoSaveStatusImpl(NoSave noSave, String userName) {
            this.noSave = noSave;
            this.userName = userName;
        }

        @Override
        public NoSave getStatus() {
            return this.noSave;
        }

        @Override
        public void toggleStatus() throws FriendException {
            NoSaveIQ noSaveMsg = NoSaveIQ.getNoSaveSetMessage(this.userName, this.noSave == NoSave.ENABLED ? NoSave.DISABLED : NoSave.ENABLED);
            NoSaveIQListener.this.connection.sendPacket(noSaveMsg);
        }
    }

    private class FriendPresenceListener
    implements EventListener<FriendPresenceEvent> {
        private FriendPresenceListener() {
        }

        @Override
        public void handleEvent(FriendPresenceEvent event) {
            if (event.getType() == FriendPresenceEvent.Type.ADDED) {
                NoSaveIQListener.this.updateNewPresenceNoSave((FriendPresence)event.getData());
            }
        }
    }
}

