/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.filetransfer;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.limewire.friend.api.FileMetaData;
import org.limewire.friend.impl.util.PresenceUtils;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.xmpp.client.impl.messages.InvalidIQException;
import org.limewire.xmpp.client.impl.messages.filetransfer.XMPPFileMetaData;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FileTransferIQ
extends IQ {
    private static Log LOG = LogFactory.getLog(FileTransferIQ.class);
    private final FileMetaData fileMetaData;
    private final TransferType transferType;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileTransferIQ(XmlPullParser parser) throws IOException, XmlPullParserException, InvalidIQException {
        XMPPFileMetaData parsedMetaData = null;
        TransferType parsedTransferType = null;
        do {
            int eventType;
            if ((eventType = parser.getEventType()) == 2) {
                if (parser.getName().equals("file-transfer")) {
                    String transferTypeValue = parser.getAttributeValue(null, "type");
                    if (transferTypeValue == null) {
                        throw new InvalidIQException("no transfer type specified");
                    }
                    try {
                        parsedTransferType = TransferType.valueOf(transferTypeValue);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new InvalidIQException("unknown transfer type: " + transferTypeValue);
                    }
                } else {
                    if (!parser.getName().equals("file")) continue;
                    parsedMetaData = new XMPPFileMetaData(parser);
                    continue;
                }
            }
            if (eventType == 3 && parser.getName().equals("file-transfer")) break;
        } while (parser.nextTag() != 1);
        if (parsedMetaData != null && parsedTransferType != null) {
            this.fileMetaData = parsedMetaData;
            this.transferType = parsedTransferType;
            return;
        }
        throw new InvalidIQException(MessageFormat.format("parsedMetaData {0}, parsedTransferType {1}", new Object[]{parsedMetaData, parsedTransferType}));
    }

    public FileTransferIQ(FileMetaData fileMetaData, TransferType transferType) {
        this.fileMetaData = fileMetaData;
        this.transferType = transferType;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    @Override
    public String getChildElementXML() {
        String fileTransfer = "<file-transfer xmlns='jabber:iq:lw-file-transfer' type='" + this.transferType.toString() + "'>";
        if (this.fileMetaData != null) {
            fileTransfer = fileTransfer + this.toXML(this.fileMetaData.getSerializableMap());
        }
        fileTransfer = fileTransfer + "</file-transfer>";
        return fileTransfer;
    }

    private String toXML(Map<String, String> data) {
        StringBuilder fileMetadata = new StringBuilder("<file>");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            fileMetadata.append("<").append(entry.getKey()).append(">");
            fileMetadata.append(PresenceUtils.escapeForXML(entry.getValue()));
            fileMetadata.append("</").append(entry.getKey()).append(">");
        }
        fileMetadata.append("</file>");
        return fileMetadata.toString();
    }

    public static IQProvider getIQProvider() {
        return new FileTransferIQProvider();
    }

    private static class FileTransferIQProvider
    implements IQProvider {
        private FileTransferIQProvider() {
        }

        @Override
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            try {
                return new FileTransferIQ(parser);
            }
            catch (InvalidIQException ie) {
                LOG.debug("invalid iq", ie);
                return null;
            }
        }
    }

    public static enum TransferType {
        OFFER,
        REQUEST;

    }
}

