/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl.messages.discoinfo;

import java.net.URI;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.listener.BlockingEvent;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.xmpp.client.impl.XMPPFriendConnectionImpl;

public class DiscoInfoListener
implements PacketListener {
    private static final Log LOG = LogFactory.getLog(DiscoInfoListener.class);
    private final FriendConnection connection;
    private final XMPPConnection smackConnection;
    private final XMPPConnectionListener connectionListener = new XMPPConnectionListener();
    private ListenerSupport<FriendConnectionEvent> connectionSupport;
    private ListenerSupport<FriendPresenceEvent> friendPresenceSupport;
    private final FriendPresenceListener friendPresenceListener = new FriendPresenceListener();
    private final PacketFilter packetFilter = new DiscoPacketFilter();
    private final FeatureRegistry featureRegistry;

    public DiscoInfoListener(FriendConnection connection, XMPPConnection smackConnection, FeatureRegistry featureRegistry) {
        this.connection = connection;
        this.smackConnection = smackConnection;
        this.featureRegistry = featureRegistry;
    }

    public void addListeners(ListenerSupport<FriendConnectionEvent> connectionSupport, ListenerSupport<FriendPresenceEvent> friendPresenceSupport) {
        this.connectionSupport = connectionSupport;
        this.friendPresenceSupport = friendPresenceSupport;
        connectionSupport.addListener(this.connectionListener);
        friendPresenceSupport.addListener(this.friendPresenceListener);
        this.smackConnection.addPacketListener(this, this.packetFilter);
    }

    @Override
    public void processPacket(Packet packet) {
        DiscoverInfo discoverInfo = (DiscoverInfo)packet;
        String from = discoverInfo.getFrom();
        if (from == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("null from field: {0}", (Object)discoverInfo.getChildElementXML());
            }
            return;
        }
        FriendPresence friendPresence = this.matchValidPresence(from);
        if (friendPresence == null && !this.isForThisConnection(from)) {
            LOG.debugf("no presence found for and not for this connection: {0}", (Object)from);
            return;
        }
        String featureInitializer = friendPresence != null ? friendPresence.getPresenceId() : from;
        for (URI uri : this.featureRegistry.getAllFeatureUris()) {
            if (!discoverInfo.containsFeature(uri.toASCIIString())) continue;
            LOG.debugf("initializing feature {0} for {1}", (Object)uri.toASCIIString(), (Object)featureInitializer);
            this.featureRegistry.get(uri).initializeFeature(friendPresence);
        }
    }

    public void cleanup() {
        if (this.connectionListener != null) {
            this.connectionSupport.removeListener(this.connectionListener);
        }
        if (this.friendPresenceSupport != null) {
            this.friendPresenceSupport.removeListener(this.friendPresenceListener);
        }
        this.smackConnection.removePacketListener(this);
    }

    private void discoverFeatures(String entityName) {
        try {
            ServiceDiscoveryManager serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(this.smackConnection);
            if (serviceDiscoveryManager != null) {
                LOG.debugf("discovering presence: {0}", (Object)entityName);
                serviceDiscoveryManager.discoverInfo(entityName);
            } else {
                LOG.debug("no service discovery manager");
            }
        }
        catch (XMPPException exception) {
            LOG.info(exception.getMessage(), exception);
            if (exception.getXMPPError() == null || !exception.getXMPPError().getCondition().equals(XMPPError.Condition.feature_not_implemented.toString())) {
                // empty if block
            }
        }
    }

    private boolean isForThisConnection(String from) {
        return this.connection.getConfiguration().getServiceName().equals(from);
    }

    private FriendPresence matchValidPresence(String from) {
        FriendPresence presence;
        Friend friend = this.connection.getFriend(StringUtils.parseBareAddress(from));
        if (friend != null && (presence = friend.getPresences().get(from)) != null) {
            return presence;
        }
        return null;
    }

    private static class DiscoPacketFilter
    implements PacketFilter {
        private DiscoPacketFilter() {
        }

        @Override
        public boolean accept(Packet packet) {
            return packet instanceof DiscoverInfo && (((DiscoverInfo)packet).getType() == IQ.Type.SET || ((DiscoverInfo)packet).getType() == IQ.Type.RESULT);
        }
    }

    private class XMPPConnectionListener
    implements EventListener<FriendConnectionEvent> {
        private XMPPConnectionListener() {
        }

        @Override
        @BlockingEvent(queueName="feature discovery")
        public void handleEvent(FriendConnectionEvent event) {
            if (!(event.getSource() instanceof XMPPFriendConnectionImpl)) {
                return;
            }
            if (event.getType() == FriendConnectionEvent.Type.CONNECTED) {
                DiscoInfoListener.this.discoverFeatures(DiscoInfoListener.this.connection.getConfiguration().getServiceName());
            }
        }
    }

    private class FriendPresenceListener
    implements EventListener<FriendPresenceEvent> {
        private FriendPresenceListener() {
        }

        @Override
        @BlockingEvent(queueName="feature discovery")
        public void handleEvent(FriendPresenceEvent event) {
            if (event.getType() == FriendPresenceEvent.Type.ADDED) {
                DiscoInfoListener.this.discoverFeatures(((FriendPresence)event.getData()).getPresenceId());
            }
        }
    }
}

